---
name: i.biomass
description: Computes biomass growth, precursor of crop yield calculation.
keywords: [ imagery, biomass, FPAR, yield ]
---

# i.biomass

Computes biomass growth, precursor of crop yield calculation.

=== "Command line"

    **i.biomass**
    **fpar**=*name*
    **lightuse_efficiency**=*name*
    **latitude**=*name*
    **dayofyear**=*name*
    **transmissivity_singleway**=*name*
    **water_availability**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.biomass fpar=name lightuse_efficiency=name latitude=name dayofyear=name transmissivity_singleway=name water_availability=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.biomass***",
        **fpar**,
        **lightuse_efficiency**,
        **latitude**,
        **dayofyear**,
        **transmissivity_singleway**,
        **water_availability**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.biomass", fpar="name", lightuse_efficiency="name", latitude="name", dayofyear="name", transmissivity_singleway="name", water_availability="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_biomass*(**fpar**,
        **lightuse_efficiency**,
        **latitude**,
        **dayofyear**,
        **transmissivity_singleway**,
        **water_availability**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_biomass(fpar="name", lightuse_efficiency="name", latitude="name", dayofyear="name", transmissivity_singleway="name", water_availability="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **fpar**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of fPAR raster map  
    **lightuse_efficiency**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of light use efficiency raster map (UZB:cotton=1.9)  
    **latitude**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of degree latitude raster map [dd.ddd]  
    **dayofyear**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Day of Year raster map [1-366]  
    **transmissivity_singleway**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of single-way transmissivity raster map [0.0-1.0]  
    **water_availability**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of water availability raster map [0.0-1.0]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output daily biomass growth raster map [kg/ha/d]  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **fpar** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of fPAR raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **lightuse_efficiency** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of light use efficiency raster map (UZB:cotton=1.9)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **latitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of degree latitude raster map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Day of Year raster map [1-366]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivity_singleway** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of single-way transmissivity raster map [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **water_availability** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of water availability raster map [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output daily biomass growth raster map [kg/ha/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **fpar** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of fPAR raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **lightuse_efficiency** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of light use efficiency raster map (UZB:cotton=1.9)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **latitude** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of degree latitude raster map [dd.ddd]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Day of Year raster map [1-366]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivity_singleway** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of single-way transmissivity raster map [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **water_availability** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of water availability raster map [0.0-1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output daily biomass growth raster map [kg/ha/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.biomass* calculates the biomass growth for a day after \[1\]\[2\].
Input:

- fPAR, the modified Photosynthetic Active Radiation for crops.
- Light Use Efficiency \[0.0-1.0\], in Uzbekistan cotton is at 1.9 most
  of the time.
- Latitude \[0.0-90.0\], from *r.latlong*.
- DOY \[1-366\].
- Transmissivity of the atmosphere single-way \[0.0-1.0\], mostly around
  0.7+ in clear sky.
- Water availability \[0.0-1.0\], possibly using direct output from
  *i.eb.evapfr*.

## NOTES

*i.biomass* can use the output of *i.eb.evapfr* directly as water
availability input.

## TODO

Remove Latitude, DOY and Tsw from input and replace with a raster input
compatible with *r.sun* output.

## REFERENCES

\[1\] Bastiaanssen, W.G.M., Ali, S., 2002. A new crop yield forecasting
model based on satellite measurements applied across the Indus Basin,
Pakistan. Agriculture, Ecosystems and Environment, 94(3):321-340.
([PDF](https://edepot.wur.nl/206553))

\[2\] Chemin, Y., Platonov, A., Abdullaev, I., Ul-Hassan, M. 2005.
Supplementing farm level water productivity assessment by remote sensing
in transition economies. Water International. 30(4):513-521.

## SEE ALSO

*[i.eb.evapfr](i.eb.evapfr.md), [r.latlong](r.latlong.md),
[r.sun](r.sun.md)*

## AUTHOR

Yann Chemin, Bec de Mortagne, France

## SOURCE CODE

Available at: [i.biomass source code](https://github.com/OSGeo/grass/tree/main/imagery/i.biomass)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.biomass))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
