---
name: v.to.3d
description: Performs transformation of 2D vector features to 3D.
keywords: [ vector, geometry, 3D ]
---

# v.to.3d

Performs transformation of 2D vector features to 3D.

=== "Command line"

    **v.to.3d**
    [**-rt**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**column**=*name*]
    [**height**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.to.3d input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.to.3d***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid"*,
        **output**,
        **column**=*None*,
        **height**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.to.3d", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_to_3d*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid"*,
        **output**,
        **column**=*None*,
        **height**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_to_3d(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column used for height  
    &nbsp;&nbsp;&nbsp;&nbsp;Can be used for reverse transformation, to store height of points  
    **height**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed height for 3D vector features  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse transformation; 3D vector features to 2D  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not copy attribute table  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column used for height  
    &nbsp;&nbsp;&nbsp;&nbsp;Can be used for reverse transformation, to store height of points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **height** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed height for 3D vector features  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse transformation; 3D vector features to 2D  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not copy attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column used for height  
    &nbsp;&nbsp;&nbsp;&nbsp;Can be used for reverse transformation, to store height of points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **height** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed height for 3D vector features  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse transformation; 3D vector features to 2D  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not copy attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *v.to.3d* module is used to transform 2D vector features to 3D.
Height (z-coordinate) of 3D vector features can be specified by
**height** parameter as fixed value or by **column** parameter.

The flag **-r** enables to perform reverse transformation, i.e.,
transform 3D vector to 2D by omitting z-coordinate. The height of input
3D features can be optionally stored in **column**.

## NOTES

When transforming 2D vector features to 3D based on attribute, all NULL
values are silently converted to height 0.0.

The reverse transformation, 2D to 3D, is possible for points and lines.
In the case of lines, the reverse transformation should be used only
when all vertices of a line have the same z-coordinate (for example
contours).

## EXAMPLES

### Transform 2D vector features to 3D

```sh
# convert z-values from string to double
v.db.addcolumn map=geodetic_pts columns="Z_VALUE_D double precision"
v.db.update map=geodetic_pts column=Z_VALUE_D qcolumn=Z_VALUE
v.db.select map=geodetic_pts columns=cat,Z_VALUE,Z_VALUE_D

# convert 2D vector point map to 3D based on attribute
v.to.3d input=geodetic_pts out=geodetic_pts_3d column=Z_VALUE_D
```

### Transform 3D vector features to 2D

```sh
v.to.3d -rt input=elev_lid792_bepts output=elev_lid_2d
```

## SEE ALSO

*[v.transform](v.transform.md), [v.extrude](v.extrude.md),
[v.drape](v.drape.md)*

## AUTHOR

Martin Landa, Czech Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [v.to.3d source code](https://github.com/OSGeo/grass/tree/main/vector/v.to.3d)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.to.3d))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
