---
name: v.patch
description: Creates a new vector map by combining other vector maps.
keywords: [ vector, geometry, level1 ]
---

# v.patch

Creates a new vector map by combining other vector maps.

=== "Command line"

    **v.patch**
    [**-nzeab**]
    **input**=*name* [,*name*,...]
    **output**=*name*
    [**bbox**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.patch input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.patch***",
        **input**,
        **output**,
        **bbox**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.patch", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_patch*(**input**,
        **output**,
        **bbox**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_patch(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **bbox**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map where bounding boxes of input vector maps are written to  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not expect input with topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Applicable when input is points without topology  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Expect z coordinate even when not using topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Applicable when input is points with z coordinate but without topology  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Copy also attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Only the table of layer 1 is currently supported  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Append files to existing file (overwriting existing files must be activated)  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **bbox** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map where bounding boxes of input vector maps are written to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *z*, *e*, *a*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not expect input with topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applicable when input is points without topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Expect z coordinate even when not using topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applicable when input is points with z coordinate but without topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Copy also attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only the table of layer 1 is currently supported  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Append files to existing file (overwriting existing files must be activated)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **bbox** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map where bounding boxes of input vector maps are written to  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *z*, *e*, *a*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not expect input with topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applicable when input is points without topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Expect z coordinate even when not using topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applicable when input is points with z coordinate but without topology  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Copy also attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only the table of layer 1 is currently supported  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Append files to existing file (overwriting existing files must be activated)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.patch* allows the user to combine any number of vector maps together
to create one composite vector map. If the table structures are
identical, attributes are transferred to the new table.

## NOTES

Any vectors that are duplicated among the maps being patched together
(e.g., border lines) will have to be edited or removed after *v.patch*
is run. Such editing can be done automatically using
*[v.clean](v.clean.md)*.

Lines may need to be snapped with *[v.clean](v.clean.md)
tool=snap,break,rmdupl*.

Boundaries may need to be cleaned with *[v.clean](v.clean.md)
tool=break,rmdupl,rmsa* repeatedly until the *rmsa* tool (Remove small
angles at nodes) no longer modifies any boundaries. If vector topology
is still not clean, boundaries may also need to be snapped with
*[v.clean](v.clean.md) tool=snap,break,rmdupl*.

When using the *-e* flag, *v.patch* shifts category (cat) values in the
output so that category numbers from the different input maps do not
overlap. This shift is applied to both the category values of the
features and the category values in the attribute tables. Hence, there
is no need to run *[v.category](v.category.md)* and
*[v.db.update](v.db.update.md)* beforehand.

When using the *-a* flag, the user has to make sure that the features in
the different maps added to the output map do not have overlapping
category numbers, unless identical category numbers reflect identical
attributes, otherwise the attributes of the added maps are lost. To
avoid this, the user can use *v.category option=sum* to change category
values of some of the maps before patching.

## EXAMPLES

Patch together two maps with mixed feature types:

```sh
   v.patch input=geology,streams out=geol_streams
```

Append one map to another:

```sh
   g.copy vect=roads,transport
   v.patch -a input=railroads output=transport --overwrite
```

## SEE ALSO

*[v.clean](v.clean.md), [v.build](v.build.md), [v.select](v.select.md),
[v.overlay](v.overlay.md)*

## AUTHORS

Dave Gerdes, U.S.Army Construction Engineering Research Laboratory  
Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [v.patch source code](https://github.com/OSGeo/grass/tree/main/vector/v.patch)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.patch))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
