---
name: v.net.components
description: Computes strongly and weakly connected components in the network.
keywords: [ vector, network, components ]
---

# v.net.components

Computes strongly and weakly connected components in the network.

=== "Command line"

    **v.net.components**
    [**-a**]
    **input**=*name*
    [**arc_layer**=*string*]
    [**node_layer**=*string*]
    [**arc_column**=*name*]
    [**arc_backward_column**=*name*]
    [**node_column**=*string*]
    **output**=*name*
    **method**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.net.components input=name output=name method=weak
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.net.components***",
        **input**,
        **arc_layer**=*"1"*,
        **node_layer**=*"2"*,
        **arc_column**=*None*,
        **arc_backward_column**=*None*,
        **node_column**=*None*,
        **output**,
        **method**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.net.components", input="name", output="name", method="weak")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_net_components*(**input**,
        **arc_layer**=*"1"*,
        **node_layer**=*"2"*,
        **arc_column**=*None*,
        **arc_backward_column**=*None*,
        **node_column**=*None*,
        **output**,
        **method**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_net_components(input="name", output="name", method="weak")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **arc_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **node_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **arc_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc forward/both direction(s) cost column (number)  
    **arc_backward_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc backward direction cost column (number)  
    **node_column**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node cost column (number)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of components  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *weak, strong*  
    &nbsp;&nbsp;&nbsp;&nbsp;**weak**: Weakly connected components  
    &nbsp;&nbsp;&nbsp;&nbsp;**strong**: Strongly connected components  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add points on nodes  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **arc_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **node_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **arc_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc forward/both direction(s) cost column (number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **arc_backward_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc backward direction cost column (number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **node_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node cost column (number)  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of components  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *weak, strong*  
    &nbsp;&nbsp;&nbsp;&nbsp;**weak**: Weakly connected components  
    &nbsp;&nbsp;&nbsp;&nbsp;**strong**: Strongly connected components  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add points on nodes  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **arc_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **node_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **arc_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc forward/both direction(s) cost column (number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **arc_backward_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc backward direction cost column (number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **node_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node cost column (number)  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of components  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *weak, strong*  
    &nbsp;&nbsp;&nbsp;&nbsp;**weak**: Weakly connected components  
    &nbsp;&nbsp;&nbsp;&nbsp;**strong**: Strongly connected components  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add points on nodes  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.net.components* computes the weakly and strongly connected components
in a network.

## NOTES

Two nodes, *u* and *v* are in the same strongly connected component if
there are directed paths from *u* to *v* and from *v* to *u*. The nodes
are in the same weakly connected component if, ignoring edge directions,
there is a path between them.

The type of components is specified by **method** parameter.
*v.net.components* creates a table and links it to layer 1. This table
contains only two integer columns: *cat* and *comp*. If a point or both
endpoints of a line belong to the same component then the point/line is
written to the output map and appropriate information is stored in the
table. If **-a** flag is set then new points are added on the nodes
without points. These points have category numbers larger than any
category used in the input map.

One-way roads can be defined by assigning a cost of -1 to the
appropriate cost column (**arc_column** or **arc_backward_column**).
This affects only strongly connected components. Network nodes can be
closed by assigning a cost of -1 to the node cost column. All nodes with
a cost \< 0 can not be traversed and are end points, while all nodes
with a cost ≥ 0 can be traversed. This affects both weakly and strongly
connected components.

## EXAMPLES

Any road network should form a single strongly connected component.
Otherwise, it is impossible to travel between some places.

```sh
v.net.components input=roads output=roads_components method=strong
```

## SEE ALSO

*[v.net](v.net.md), [v.category](v.category.md)*

## AUTHORS

Daniel Bundala, Google Summer of Code 2009, Student  
Wolf Bergenheim, Mentor  
Markus Metz

## SOURCE CODE

Available at: [v.net.components source code](https://github.com/OSGeo/grass/tree/main/vector/v.net.components)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.net.components))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
