---
name: v.in.wfs.py
description: Imports GetFeature from a WFS server.
keywords: [ vector, import, OGC web services, OGC WFS ]
---

# v.in.wfs.py

Imports GetFeature from a WFS server.

=== "Command line"

    **v.in.wfs.py**
    [**-lr**]
    **url**=*string*
    **output**=*name*
    [**name**=*string* [,*string*,...]]
    [**layer**=*string* [,*string*,...]]
    [**srs**=*string*]
    [**maximum_features**=*integer*]
    [**start_index**=*integer*]
    [**version**=*string*]
    [**username**=*string*]
    [**password**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.wfs.py url=string output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.wfs.py***",
        **url**,
        **output**,
        **name**=*None*,
        **layer**=*None*,
        **srs**=*None*,
        **maximum_features**=*None*,
        **start_index**=*None*,
        **version**=*"1.0.0"*,
        **username**=*None*,
        **password**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.wfs.py", url="string", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_wfs_py*(**url**,
        **output**,
        **name**=*None*,
        **layer**=*None*,
        **srs**=*None*,
        **maximum_features**=*None*,
        **start_index**=*None*,
        **version**=*"1.0.0"*,
        **username**=*None*,
        **password**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_wfs_py(url="string", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL starting with 'http' and ending in '?'  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **name**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated names of data layers to download  
    **layer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data layers to import  
    **srs**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specify alternate spatial reference system (example: EPSG:4326)  
    &nbsp;&nbsp;&nbsp;&nbsp;The given code must be supported by the server, consult the capabilities file  
    **maximum_features**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of features to download  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: unlimited)  
    **start_index**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip earlier feature IDs and start downloading at this one  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: start with the first feature)  
    **version**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;version of WFS, e.g.:1.0.0 or 2.0.0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0.0*  
    **username**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username or file with username or environment variable name with username  
    **password**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password or file with password or environment variable name with password  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Download server capabilities to 'wms_capabilities.xml' in the current directory and exit  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Restrict fetch to features which touch the current region  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL starting with 'http' and ending in '?'  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **name** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated names of data layers to download  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data layers to import  
    **srs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specify alternate spatial reference system (example: EPSG:4326)  
    &nbsp;&nbsp;&nbsp;&nbsp;The given code must be supported by the server, consult the capabilities file  
    **maximum_features** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of features to download  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: unlimited)  
    **start_index** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip earlier feature IDs and start downloading at this one  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: start with the first feature)  
    **version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;version of WFS, e.g.:1.0.0 or 2.0.0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0.0*  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username or file with username or environment variable name with username  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password or file with password or environment variable name with password  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Download server capabilities to 'wms_capabilities.xml' in the current directory and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restrict fetch to features which touch the current region  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base URL starting with 'http' and ending in '?'  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **name** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma separated names of data layers to download  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of data layers to import  
    **srs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specify alternate spatial reference system (example: EPSG:4326)  
    &nbsp;&nbsp;&nbsp;&nbsp;The given code must be supported by the server, consult the capabilities file  
    **maximum_features** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of features to download  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: unlimited)  
    **start_index** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip earlier feature IDs and start downloading at this one  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: start with the first feature)  
    **version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;version of WFS, e.g.:1.0.0 or 2.0.0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0.0*  
    **username** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Username or file with username or environment variable name with username  
    **password** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Password or file with password or environment variable name with password  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Download server capabilities to 'wms_capabilities.xml' in the current directory and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restrict fetch to features which touch the current region  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.wfs* imports OGC WFS maps (Web Feature Service) from external
servers.

## EXAMPLES

### WFS import without credentials

Import of Copernicus Sentinel-2 satellite scene footprints:

```sh
# run in Latitude-Longitude project (EPGS code 4326):
# download "sentinel:mgrs" layer:
v.in.wfs url="https://geoserver.mundialis.de/geoserver/sentinel/wfs?" name="sentinel:mgrs" output=sentinel2_mgrs
# download NRW ALKIS "ave:Flurstueck" attribute:
# set the AOI beforehand with g.region and limit import to current region with -r flag
v.in.wfs url="https://www.wfs.nrw.de/geobasis/wfs_nw_alkis_vereinfacht?" -r output=wfs_alkis_vereinfacht srs=25832
name="ave:Flurstueck" version="2.0.0" layer="Flurstueck"
```

### WFS import with API key

Download 25 ship wrecks from LINZ data service:  
(first create yourself a free API key at
<http://data.linz.govt.nz/p/web-services/>)

```sh
# run in LatLong project:
URL='http://wfs.data.linz.govt.nz/<PUT YOUR API KEY HERE>/wfs?'

# download list of available layers to wms_capabilities.xml
v.in.wfs -l url="$URL"
```

From that file we learn that the shipwreck layer is called "`v:x633`"
and that EPSG code 4326 (LatLong WGS84) is a supported SRS for this data
layer.

```sh
v.in.wfs url="$URL" output=linz_hydro_25_wrecks name="v:x633" srs="EPSG:4326" max=25
```

## REQUIREMENTS

The OGR library on the system needs to be compiled with Xerces C++ XML
Parser support (for GML).

## SEE ALSO

*[g.region](g.region.md), [r.in.wms](r.in.wms.md),
[v.import](v.import.md), [v.in.ogr](v.in.ogr.md)*

## AUTHORS

Markus Neteler, Hamish Bowman

## SOURCE CODE

Available at: [v.in.wfs source code](https://github.com/OSGeo/grass/tree/main/scripts/v.in.wfs)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.in.wfs))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
