---
name: t.vect.list.py
description: Lists registered maps of a space time vector dataset.
keywords: [ temporal, map management, vector, list, time ]
---

# t.vect.list.py

Lists registered maps of a space time vector dataset.

=== "Command line"

    **t.vect.list.py**
    [**-u**]
    **input**=*name*
    [**order**=*string* [,*string*,...]]
    [**columns**=*string* [,*string*,...]]
    [**where**=*sql_query*]
    [**method**=*string*]
    [**separator**=*character*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.vect.list.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.vect.list.py***",
        **input**,
        **order**=*"start_time"*,
        **columns**=*"name,layer,mapset,start_time,end_time"*,
        **where**=*None*,
        **method**=*"cols"*,
        **separator**=*"pipe"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.vect.list.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_vect_list_py*(**input**,
        **order**=*"start_time"*,
        **columns**=*"name,layer,mapset,start_time,end_time"*,
        **where**=*None*,
        **method**=*"cols"*,
        **separator**=*"pipe"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_vect_list_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    **order**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, layer, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, points, lines, boundaries, centroids, faces, kernels, primitives, nodes, areas, islands, holes, volumes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start_time*  
    **columns**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, layer, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, points, lines, boundaries, centroids, faces, kernels, primitives, nodes, areas, islands, holes, volumes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *name,layer,mapset,start_time,end_time*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for data listing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cols, comma, delta, deltagaps, gran*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cols*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **order** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, layer, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, points, lines, boundaries, centroids, faces, kernels, primitives, nodes, areas, islands, holes, volumes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start_time*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, layer, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, points, lines, boundaries, centroids, faces, kernels, primitives, nodes, areas, islands, holes, volumes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *name,layer,mapset,start_time,end_time*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for data listing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cols, comma, delta, deltagaps, gran*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cols*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **order** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, layer, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, points, lines, boundaries, centroids, faces, kernels, primitives, nodes, areas, islands, holes, volumes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start_time*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, layer, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, points, lines, boundaries, centroids, faces, kernels, primitives, nodes, areas, islands, holes, volumes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *name,layer,mapset,start_time,end_time*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for data listing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cols, comma, delta, deltagaps, gran*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cols*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *t.vect.list* module provides the same functionality as
[t.rast.list](t.rast.list.md), the only difference is the vector map
layer metadata.

## EXAMPLE

### Default query

This example show a relative space time vector dataset with the first
three maps with a range of years, instead the last five are valid only
for one year:

```sh
t.vect.list shoreline@shoreline
name|layer|mapset|start_time|end_time
shoreline_1849_1873|None|shoreline|1849|1873
shoreline_1925_1946|None|shoreline|1925|1946
shoreline_1970_1988|None|shoreline|1970|1988
shoreline_1997|None|shoreline|1997|None
shoreline_1998|None|shoreline|1998|None
shoreline_2003|None|shoreline|2003|None
shoreline_2004|None|shoreline|2004|None
shoreline_2009|None|shoreline|2009|None
```

### Using method option

Method option is able to show vector in different way. By default *cols*
value is used, the value *deltagaps* will print the delta between maps
and also the gaps if they exist (like in this example).

```sh
t.vect.list method=deltagaps input=shoreline
id|name|layer|mapset|start_time|end_time|interval_length|distance_from_begin
shoreline_1849_1873@shoreline|shoreline_1849_1873|None|shoreline|1849|1873|24|0
None|None|None|None|1873|1925|52|24
shoreline_1925_1946@shoreline|shoreline_1925_1946|None|shoreline|1925|1946|21|76
None|None|None|None|1946|1970|24|97
shoreline_1970_1988@shoreline|shoreline_1970_1988|None|shoreline|1970|1988|18|121
None|None|None|None|1988|1997|9|139
shoreline_1997@shoreline|shoreline_1997|None|shoreline|1997|None|None|148
None|None|None|None|1997|1998|1|148
shoreline_1998@shoreline|shoreline_1998|None|shoreline|1998|None|None|149
None|None|None|None|1998|2003|5|149
shoreline_2003@shoreline|shoreline_2003|None|shoreline|2003|None|None|154
None|None|None|None|2003|2004|1|154
shoreline_2004@shoreline|shoreline_2004|None|shoreline|2004|None|None|155
None|None|None|None|2004|2009|5|155
shoreline_2009@shoreline|shoreline_2009|None|shoreline|2009|None|None|160
```

## SEE ALSO

*[g.list](g.list.md), [t.create](t.create.md), [t.info](t.info.md),
[t.list](t.list.md), [t.rast.list](t.rast.list.md),
[t.rast3d.list](t.rast3d.list.md)*

## AUTHOR

Sören Gebbert

## SOURCE CODE

Available at: [t.vect.list source code](https://github.com/OSGeo/grass/tree/main/temporal/t.vect.list)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.vect.list))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
