---
name: r.spreadpath
description: Recursively traces the least cost path backwards to cells from which the cumulative cost was determined.
keywords: [ raster, fire, cumulative costs ]
---

# r.spreadpath

Recursively traces the least cost path backwards to cells from which the cumulative cost was determined.

=== "Command line"

    **r.spreadpath**
    **x_input**=*name*
    **y_input**=*name*
    [**coordinates**=*east,north* [,*east,north*,...]]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.spreadpath x_input=name y_input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.spreadpath***",
        **x_input**,
        **y_input**,
        **coordinates**=*None*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.spreadpath", x_input="name", y_input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_spreadpath*(**x_input**,
        **y_input**,
        **coordinates**=*None*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_spreadpath(x_input="name", y_input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **x_input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing back-path easting information  
    **y_input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing back-path northing information  
    **coordinates**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The map E and N grid coordinates of starting points  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **x_input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing back-path easting information  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **y_input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing back-path northing information  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The map E and N grid coordinates of starting points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **x_input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing back-path easting information  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **y_input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing back-path northing information  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The map E and N grid coordinates of starting points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.spreadpath* is part of the wildfire simulation toolset. Preparational
steps for the fire simulation are the calculation of the rate of spread
(ROS) with *r.ros*, and the creating of spread map with *r.spread*.
Eventually, the fire path(s) based on starting point(s) are calculated
with *r.spreadpath*.

*r.spreadpath* recursively traces the least cost path backwards to the
origin, given backlink information input map layers and target locations
from where paths are to be traced. The backlink information map layers
record each cell's backlink UTM northing (the y_input) and easting (the
x_input) coordinates from which the cell's cumulative cost was
determined.

The backlink inputs can be generated from another GRASS raster program
*r.spread*. One of the major applications of *r.spreadpath* along with
*r.spread* is to accurately find the least cost corridors and/or paths
on a raster setting. More information on *r.spread* and *r.spreadpath*
can be found in Xu (1994).

## Parameters

**x_input**=*name*  
Name of input raster map layer containing backlink UTM easting
coordinates.

**y_input**=*name*  
Name of input raster map layer containing backlink UTM northing
coordinates.

**coordinates**=*x,y\[,x,y,x,y, ...\]*  
Each x,y coordinate pair gives the easting and northing (respectively)
geographic coordinates of a target point from which to backwards trace
the least cost path. As many points as desired can be entered by the
user.

**output**=*name*  
Name of raster map layer to contain output. Also can be used as the map
layer of the input target points. If so used, the input target point map
will be overwritten by the output.

## REFERENCES

- Xu, Jianping, 1994, Simulating the spread of wildfires using a
  geographic information system and remote sensing, Ph. D. Dissertation,
  Rutgers University, New Brunswick, New Jersey
  ([ref](https://dl.acm.org/citation.cfm?id=921466)).

## SEE ALSO

*[r.spread](r.spread.md), [r.ros](r.ros.md)* Sample data download:
[firedemo.sh](https://grass.osgeo.org/sampledata/firedemo_grass7.sh)
(run this script within the "Fire simulation data set" project).

## AUTHORS

Jianping Xu and Richard G. Lathrop, Jr., Center for Remote Sensing and
Spatial Analysis, Rutgers University.

## SOURCE CODE

Available at: [r.spreadpath source code](https://github.com/OSGeo/grass/tree/main/raster/r.spreadpath)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.spreadpath))  
Latest change: Monday Feb 24 16:07:55 2025 in commit [4ab71fd](https://github.com/OSGeo/grass/commit/4ab71fd34113b347c3c86c736cd82ca0f6be1d4b)
