---
name: i.emissivity
description: Computes emissivity from NDVI, generic method for sparse land.
keywords: [ imagery, emissivity, land flux, energy balance ]
---

# i.emissivity

Computes emissivity from NDVI, generic method for sparse land.

=== "Command line"

    **i.emissivity**
    **input**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.emissivity input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.emissivity***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.emissivity", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_emissivity*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_emissivity(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI map [-]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output emissivity layer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output emissivity layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the NDVI map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output emissivity layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.emissivity* calculates the emissivity in the longwave radiation
spectrum, according to the semi-empirical equation related to NDVI by
Caselles et al. (1997), valid in the NDVI range of 0.16 to 0.74
(Bastiaanssen, 1995).

Caselles et al. (1997) give reference (in Table 3 and Figure 2) to both
the NDVI range used (0.15 - 0.71) and the corresponding emissivity range
used (0.97 - 0.99).

The emissivity is the efficiency of longwave energy returning to the
atmosphere from the skin surface. The skin surface receives heat from
the thermal infrared radiation of the Sun, through atmospheric
interaction. A part is returned to the atmosphere fastly, and another
part is kept in the surface skin to be returned later. In more
scientific terms, the grey body radiation is equal to the black body
radiation times the emissivity.

## REFERENCES

- Bastiaanssen, W.G.M., 1995. Estimation of Land surface parameters by
  remote sensing under clear-sky conditions. PhD thesis, Wageningen
  University, Wageningen, The Netherlands.
  ([PDF](https://edepot.wur.nl/206553))
- Caselles, V., C. Coll, and E. Valor, 1997. Land surface emissivity and
  temperature determination in the whole HAPEX-Sahel area from AVHRR
  data. International Journal of Remote Sensing 18(5):1009-1027.
- Rubio, E., V. Caselles, and C. Badenas, 1997. Emissivity measurements
  of several soils and vegetation types in the 8-14 µm wave band:
  Analysis of two field methods. Remote Sensing of Environment 59(3):
  490-521.

## SEE ALSO

*[i.eb.netrad](i.eb.netrad.md)*

## AUTHOR

Yann Chemin, GRASS Development Team

## SOURCE CODE

Available at: [i.emissivity source code](https://github.com/OSGeo/grass/tree/main/imagery/i.emissivity)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.emissivity))  
Latest change: Thursday Feb 27 06:04:10 2025 in commit [0ecd9fd](https://github.com/OSGeo/grass/commit/0ecd9fd24c0e51fe8a1cd2933f63c8218cc99b47)
