---
name: g.tempfile
description: Creates a temporary file and prints it's file name.
keywords: [ general, support, scripts ]
---

# g.tempfile

Creates a temporary file and prints it's file name.

=== "Command line"

    **g.tempfile**
    [**-d**]
    **pid**=*integer*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.tempfile pid=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.tempfile***",
        **pid**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.tempfile", pid=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_tempfile*(**pid**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_tempfile(pid=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **pid**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Process id to use when naming the tempfile  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dry run - don't create a file, just prints it's file name  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **pid** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Process id to use when naming the tempfile  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dry run - don't create a file, just prints it's file name  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **pid** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Process id to use when naming the tempfile  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dry run - don't create a file, just prints it's file name  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.tempfile* is designed for shell scripts that need to use large
temporary files. GRASS provides a mechanism for temporary files that
does not depend on `/tmp/`. GRASS temporary files are created in the
data base with the assumption that there will be enough space under the
data base for large files. GRASS periodically removes temporary files
that have been left behind by programs that failed to remove them before
terminating.

*g.tempfile* creates an unique file and prints the name. The user is
required to provide a process-id which will be used as part of the name
of the file. Most Unix shells provide a way to get the process id of the
current shell. For `/bin/sh` and `/bin/csh` this is `$$`. It is
recommended that `$$` be specified as the process-id for *g.tempfile*.

## EXAMPLE

For `/bin/sh` scripts the following syntax should be used:

```sh
temp1=`g.tempfile pid=$$`
temp2=`g.tempfile pid=$$`
```

For `/bin/csh` scripts, the following can be used:

```sh
set temp1=`g.tempfile pid=$$`
set temp2=`g.tempfile pid=$$`
```

## NOTES

Each call to *g.tempfile* creates a different (i.e. unique) name.
Although GRASS does eventually get around to removing tempfiles that
have been left behind, the programmer should make every effort to remove
these files. They often get large and take up disk space. If you write
`/bin/sh` scripts, learn to use the `/bin/sh` related `trap` command. If
you write `/bin/csh` scripts, learn to use the `/bin/csh` related
`onintr` command.

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [g.tempfile source code](https://github.com/OSGeo/grass/tree/main/general/g.tempfile)
([history](https://github.com/OSGeo/grass/commits/main/general/g.tempfile))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
