---
name: d.rast.num
description: Overlays cell category values on a raster map displayed in the active graphics frame.
keywords: [ display, map annotations, raster ]
---

# d.rast.num

Overlays cell category values on a raster map displayed in the active graphics frame.

=== "Command line"

    **d.rast.num**
    [**-af**]
    **map**=*name*
    [**text_color**=*name*]
    [**grid_color**=*name*]
    [**precision**=*integer*]
    [**font**=*string*]
    [**path**=*name*]
    [**charset**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.rast.num map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.rast.num***",
        **map**,
        **text_color**=*"black"*,
        **grid_color**=*"gray"*,
        **precision**=*1*,
        **font**=*None*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.rast.num", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_rast_num*(**map**,
        **text_color**=*"black"*,
        **grid_color**=*"gray"*,
        **precision**=*1*,
        **font**=*None*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_rast_num(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **text_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **grid_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0, 1, 2, 3, 4, 5, 6, 7, 8, 9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **path**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    **charset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Align grids with raster cells  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Get text color from cell color value  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **grid_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0, 1, 2, 3, 4, 5, 6, 7, 8, 9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align grids with raster cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get text color from cell color value  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **grid_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0, 1, 2, 3, 4, 5, 6, 7, 8, 9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align grids with raster cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get text color from cell color value  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.rast.num* overlays cell category values onto a raster map layer
displayed on the user's graphics monitor. Category values will be
displayed in the text color given and scaled to fit within a single
cell. A grid outlining each map cell will also be overlain in a
user-specified color, unless it has been set to "none".

If no grid color is given the default will be used. If no map layer is
specified, the program will use whatever raster map layer is currently
displayed in the active frame on the graphics monitor.

If the **-f** flag is given the displayed number will take on the color
of the base map in that cell.

## NOTES

The user is advised to set the current region to a relatively small area
(i.e., less than 100 rows by 100 columns); otherwise, the individual
cells being displayed will be small and the category value associated
with each will be difficult to see. No data cells are indicated with
"Null".

## EXAMPLE

Distance from the streams network (North Carolina sample dataset):

```sh
g.region raster=streams_derived -p
r.grow.distance input=streams_derived distance=dist_from_streams
d.rast.num dist_from_streams -a
```

![Euclidean distance from the streams network in meters](d_rast_num_zoom.png)  
*Euclidean distance from the streams network in meters (detail, numbers
shown with d.rast.num)*

## SEE ALSO

*[d.frame](d.frame.md), [d.grid](d.grid.md), [d.rast](d.rast.md),
[d.rast.arrow](d.rast.arrow.md), [d.rast.edit](d.rast.edit.md),
[g.region](g.region.md), [r.slope.aspect](r.slope.aspect.md)*

## AUTHORS

Raghavan Srinivasan, and Chris Rewerts,  
Agricultural Engineering, Purdue University

## SOURCE CODE

Available at: [d.rast.num source code](https://github.com/OSGeo/grass/tree/main/display/d.rast.num)
([history](https://github.com/OSGeo/grass/commits/main/display/d.rast.num))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
