---
name: d.profile
description: Plots profile of a transect.
keywords: [ display, profile, raster, plot ]
---

# d.profile

Plots profile of a transect.

=== "Command line"

    **d.profile**
    [**-r**]
    **map**=*name*
    **coordinates**=*east,north* [,*east,north*,...]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.profile map=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.profile***",
        **map**,
        **coordinates**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.profile", map="name", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_profile*(**map**,
        **coordinates**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_profile(map="name", coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be profiled  
    **coordinates**=*east,north* [,*east,north*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile coordinate pairs  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use map's range recorded range  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be profiled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use map's range recorded range  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to be profiled  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Profile coordinate pairs  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use map's range recorded range  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.profile* displays the profile for a specified transect.

## SEE ALSO

*[d.where](d.where.md), [r.profile](r.profile.md),
[r.transect](r.transect.md), [wxGUI profile tool](wxGUI.md)*

## AUTHOR

Glynn Clements This program has been completely re-written for 7.0. It
bears no relation to the interactive d.profile module in previous
versions.

## SOURCE CODE

Available at: [d.profile source code](https://github.com/OSGeo/grass/tree/main/display/d.profile)
([history](https://github.com/OSGeo/grass/commits/main/display/d.profile))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
