---
name: r.mapcalc.simple.py
description: Calculates a new raster map from a simple r.mapcalc expression.
keywords: [ raster, algebra, simple ]
---

# r.mapcalc.simple.py

Calculates a new raster map from a simple r.mapcalc expression.

=== "Command line"

    **r.mapcalc.simple.py**
    [**-sqc**]
    **expression**=*string*
    [**a**=*name*]
    [**b**=*name*]
    [**c**=*name*]
    [**d**=*name*]
    [**e**=*name*]
    [**f**=*name*]
    **output**=*name*
    [**seed**=*integer*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mapcalc.simple.py expression=string output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mapcalc.simple.py***",
        **expression**,
        **a**=*None*,
        **b**=*None*,
        **c**=*None*,
        **d**=*None*,
        **e**=*None*,
        **f**=*None*,
        **output**,
        **seed**=*None*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mapcalc.simple.py", expression="string", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mapcalc_simple_py*(**expression**,
        **a**=*None*,
        **b**=*None*,
        **c**=*None*,
        **d**=*None*,
        **e**=*None*,
        **f**=*None*,
        **output**,
        **seed**=*None*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mapcalc_simple_py(expression="string", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **expression**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Formula (e.g. A-B or A\*C+B)  
    **a**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input A raster map  
    **b**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input B raster map  
    **c**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input C raster map  
    **d**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input D raster map  
    **e**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input E raster map  
    **f**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input F raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for rand() function  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quote the map names  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Case sensitive variable names  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **expression** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Formula (e.g. A-B or A\*C+B)  
    **a** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input A raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **b** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input B raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **c** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input C raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **e** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input E raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **f** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input F raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for rand() function  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *q*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quote the map names  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Case sensitive variable names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **expression** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Formula (e.g. A-B or A\*C+B)  
    **a** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input A raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **b** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input B raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **c** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input C raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **d** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **e** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input E raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **f** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input F raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for rand() function  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *q*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quote the map names  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Case sensitive variable names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.mapcalc.simple* provides a wrapper to *r.mapcalc*. Up to 6 maps can
be combined using simple expressions.

The general syntax for the **expression** follows
*[r.mapcalc](r.mapcalc.md)* expression format, for example, `A + B` or
`exp(A + B)` are valid. The variables A, B, ..., F represent raster maps
which are provided as options **a**, **b**, ..., **f**.

The result name, i.e. the output raster map, is provided using the
option **output** and, unlike *r.mapcalc* it is not part of the
expression.

This module is meant for convenience (for users and programmers) while
the *r.mapcalc* module is a better choice for more complex expressions
and advanced usage.

## NOTES

Differences to *r.mapcalc* module:

- The input raster map names and the output map raster name are separate
  from the expression (formula) which uses generic variable names (A, B,
  C, ...).
- The output raster name is not included in the expression.
- The expression is expected to be a single short one liner without the
  function `eval()`.

Differences to *r.mapcalc.simple* module in GRASS GIS 5 and 6:

- The primary purpose is not being a GUI front end to *r.mapcalc*, but a
  wrapper which allows easy building of interfaces to *r.mapcalc*
  (including GUIs).
- Whitespace (most notably spaces) are allowed (in the same way as for
  *r.mapcalc*).
- The variable names are case-insensitive to allow the original
  uppercase as well as lowercase as in option names (unless the **-c**
  flag is used).
- Option names for each map are just one letter (not amap, etc.).
- Output option name is **output** as for other modules (not outfile).
- Raster map names can be optionally quoted (the **-q** flag).
- There is no expert mode (which was just running *r.mapcalc*).
- The **expression** option is first, so it is possible to omit its name
  in the command line (just like with *r.mapcalc*).
- Overwriting of outputs is done in the same way as with other modules,
  so there is no flag to not overwrite outputs.

## EXAMPLES

### Basic examples

```sh
r.mapcalc.simple expression="0" output=zeros
r.mapcalc.simple expression="1" output=ones
r.mapcalc.simple expression="2" output=twos
```

```sh
r.mapcalc.simple expression="A + B + C" a=zeros b=ones c=twos output=result1
```

```sh
r.mapcalc.simple expression="(A * B) / 2 + 3 * C" a=zeros b=ones c=twos output=result2
```

![Figure: r.mapcalc.simple graphical user interface](r_mapcalc_simple.png)  
*Figure: r.mapcalc.simple graphical user interface*

### Example expressions

Addition:

```sh
A + B
```

No spaces around operators are not recommended for readability, but
allowed in the expression:

```sh
A+B
```

More complex expression with a function:

```sh
exp(A+C)+(B-2)*7
```

## SEE ALSO

*[r.mapcalc](r.mapcalc.md), [r3.mapcalc](r3.mapcalc.md),
[t.rast.mapcalc](t.rast.mapcalc.md), [g.region](g.region.md)*

## AUTHORS

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)  
Michael Barton, Arizona State University (updated to GRASS 5.7)  
R. Brunzema (original 5.0 Bash version)

## SOURCE CODE

Available at: [r.mapcalc.simple source code](https://github.com/OSGeo/grass/tree/main/scripts/r.mapcalc.simple)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.mapcalc.simple))  
Latest change: Thursday Nov 06 16:58:52 2025 in commit [5bb7b02](https://github.com/OSGeo/grass/commit/5bb7b0219668e549efe4d25cadebf58f0d38e957)
