---
name: i.ortho.target
description: Select or modify the imagery group target.
keywords: [ imagery, orthorectify ]
---

# i.ortho.target

Select or modify the imagery group target.

=== "Command line"

    **i.ortho.target**
    **group**=*name*
    **target_project**=*name*
    **target_mapset**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.ortho.target group=name target_project=name target_mapset=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.ortho.target***",
        **group**,
        **target_project**,
        **target_mapset**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.ortho.target", group="name", target_project="name", target_mapset="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_ortho_target*(**group**,
        **target_project**,
        **target_mapset**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_ortho_target(group="name", target_project="name", target_mapset="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group for ortho-rectification  
    **target_project**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target project (location) for ortho-rectification  
    **target_mapset**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target mapset for ortho-rectification  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **target_project** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target project (location) for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **target_mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target mapset for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **target_project** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target project (location) for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **target_mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target mapset for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.ortho.target* sets the image group target project (location) and
mapset.

## SEE ALSO

*[i.ortho.photo](i.ortho.photo.md), [i.ortho.elev](i.ortho.elev.md),
[i.ortho.camera](i.ortho.camera.md),
[g.gui.photo2image](g.gui.photo2image.md),
[g.gui.image2target](g.gui.image2target.md),
[i.ortho.init](i.ortho.init.md), [i.ortho.rectify](i.ortho.rectify.md)*

## AUTHOR

Mike Baba, DBA Systems, Inc.  
GRASS development team, 2017

## SOURCE CODE

Available at: [i.ortho.target source code](https://github.com/OSGeo/grass/tree/main/imagery/i.ortho.photo/i.ortho.target)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.ortho.photo/i.ortho.target))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
