---
name: i.cca
description: Canonical components analysis (CCA) program for image processing.
keywords: [ imagery, statistics, CCA, canonical components analysis ]
---

# i.cca

Canonical components analysis (CCA) program for image processing.

=== "Command line"

    **i.cca**
    **group**=*name*
    **subgroup**=*name*
    **signature**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.cca group=name subgroup=name signature=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.cca***",
        **group**,
        **subgroup**,
        **signature**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.cca", group="name", subgroup="name", signature="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_cca*(**group**,
        **subgroup**,
        **signature**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_cca(group="name", subgroup="name", signature="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **subgroup**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    **signature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing spectral signatures  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map prefix name  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **signature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing spectral signatures  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map prefix name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **signature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing spectral signatures  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map prefix name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**i.cca** is an image processing program that takes any number of
(raster) band files and a signature file, and outputs the same number of
raster band files transformed to provide maximum separability of the
categories indicated by the signatures. This implementation of the
canonical components transformation is based on the algorithm contained
in the [LAS image processing
system](http://dbwww.essc.psu.edu/lasdoc/user/canal.html). CCA is also
known as "Canonical components transformation".

Typically the user will use the *[g.gui.iclass](g.gui.iclass.md)*
program to collect a set of signatures and then pass those signatures
along with the raster band files to *i.cca*. The raster band file names
are specified on the command line by giving the group and subgroup that
were used to collect the signatures.

The output raster map names are built by appending a ".1", ".2", etc. to
the output raster map name specified on the command line.

### Parameters

**group**=*name*  
Name of the [imagery](i.group.md) group to which the raster band files
used belong.

**subgroup**=*name*  
Name of the [imagery](i.group.md) subgroup to which the raster band
files used belong.

**signature**=*name*  
Name of an ASCII file containing spectral signatures.

**output**=*name*  
Output raster map prefix name. The output raster map layer names are
built by appending a ".1", ".2", etc. onto the *output* name specified
by the user.

## NOTES

*i.cca* respects the current geographic region definition and the
current mask setting while performing the transformation.

## REFERENCES

Schowengerdt, Robert A. **Techniques for Image Processing and
Classification in Remote Sensing**, Academic Press, 1983.

## SEE ALSO

*[g.gui.iclass](g.gui.iclass.md), [i.gensig](i.gensig.md),
[i.cluster](i.cluster.md), [i.pca](i.pca.md), [r.covar](r.covar.md),
[r.mapcalc](r.mapcalc.md)*

## AUTHORS

David Satnik, GIS Laboratory, Central Washington University  
Ali R. Vali, University of Texas  
Semantic label support: Maris Nartiss, University of Latvia

## SOURCE CODE

Available at: [i.cca source code](https://github.com/OSGeo/grass/tree/main/imagery/i.cca)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.cca))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
