---
name: v.timestamp
description: Modifies a timestamp for a vector map. Print/add/remove a timestamp for a vector map.
keywords: [ vector, metadata, timestamp, time ]
---

# v.timestamp

Modifies a timestamp for a vector map.

Print/add/remove a timestamp for a vector map.

=== "Command line"

    **v.timestamp**
    **map**=*name*
    [**layer**=*string*]
    [**date**=*timestamp*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.timestamp map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.timestamp***",
        **map**,
        **layer**=*"1"*,
        **date**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.timestamp", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_timestamp*(**map**,
        **layer**=*"1"*,
        **date**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_timestamp(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **date**=*timestamp*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime, datetime1/datetime2, or 'none' to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: '15 jan 1994' (absolute) or '2 years' (relative)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime, datetime1/datetime2, or 'none' to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: '15 jan 1994' (absolute) or '2 years' (relative)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *timestamp*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime, datetime1/datetime2, or 'none' to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: '15 jan 1994' (absolute) or '2 years' (relative)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *timestamp*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This command has 2 modes of operation. If no **date** argument is
supplied, then the current timestamp for the vector map is printed. If a
date argument is specified, then the timestamp for the vector map is set
to the specified date(s). See examples below.

See [TIMESTAMP FORMAT](r.timestamp.md#timestamp-format) description for
details.

## NOTES

Strings containing spaces should be quoted. For specifying a range of
time, the two timestamps should be separated by a forward slash. To
remove the timestamp from a vector map, use **date=none**.

## EXAMPLES

Prints the timestamp for the "lidar" vector map. If there is no
timestamp for "lidar", nothing is printed. If there is a timestamp, one
or two time strings are printed, depending on if the timestamp for the
map consists of a single date or two dates (ie start and end dates).

```sh
v.timestamp map=lidar
```

Sets the timestamp for "lidar" to the single date "15 sep 1987".

```sh
v.timestamp map=lidar date='15 sep 1987'
```

Sets the timestamp for "lidar" to have the start date "15 sep 1987" and
the end date "20 feb 1988".

```sh
v.timestamp map=lidar date='15 sep 1987/20 feb 1988'
```

Removes the timestamp for the "lidar" vector map.

```sh
v.timestamp map=lidar date=none
```

## KNOWN ISSUES

Spaces in the timestamp value are required.

## SEE ALSO

*[v.info](v.info.md), [r.timestamp](r.timestamp.md),
[r3.timestamp](r3.timestamp.md)*

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [v.timestamp source code](https://github.com/OSGeo/grass/tree/main/vector/v.timestamp)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.timestamp))  
Latest change: Saturday Mar 29 14:59:39 2025 in commit [0bfa813](https://github.com/OSGeo/grass/commit/0bfa813b5cbca759cc4dbf4f5057354ccb94c8bf)
