---
name: v.proj
description: Re-projects a vector map from one project to the current project.
keywords: [ vector, projection, transformation, import ]
---

# v.proj

Re-projects a vector map from one project to the current project.

=== "Command line"

    **v.proj**
    [**-lzwb**]
    **project**=*name*
    [**mapset**=*name*]
    [**input**=*name*]
    [**dbase**=*path*]
    [**smax**=*float*]
    [**output**=*name*]
    [**pipeline**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.proj project=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.proj***",
        **project**,
        **mapset**=*None*,
        **input**=*None*,
        **dbase**=*None*,
        **smax**=*10000*,
        **output**=*None*,
        **pipeline**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.proj", project="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_proj*(**project**,
        **mapset**=*None*,
        **input**=*None*,
        **dbase**=*None*,
        **smax**=*10000*,
        **output**=*None*,
        **pipeline**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_proj(project="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **project**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) containing input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    **mapset**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset containing input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: name of current mapset  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map to re-project  
    **dbase**=*path*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to GRASS database of input project  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    **smax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum segment length in meters in output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Increases accuracy of reprojected shapes, disable with smax=0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10000*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map (default: input)  
    **pipeline**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;PROJ pipeline for coordinate transformation  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List vector maps in input mapset and exit  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume z coordinate is ellipsoidal height and transform if possible  
    &nbsp;&nbsp;&nbsp;&nbsp;3D vector maps only  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable wrapping to -180,180 for latlon output  
    &nbsp;&nbsp;&nbsp;&nbsp;Latlon output only, default is -180,180  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build vector topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended for massive point projection  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **project** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) containing input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **mapset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset containing input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: name of current mapset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map to re-project  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to GRASS database of input project  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **smax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum segment length in meters in output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Increases accuracy of reprojected shapes, disable with smax=0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10000*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map (default: input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **pipeline** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;PROJ pipeline for coordinate transformation  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *z*, *w*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List vector maps in input mapset and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume z coordinate is ellipsoidal height and transform if possible  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3D vector maps only  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable wrapping to -180,180 for latlon output  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Latlon output only, default is -180,180  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build vector topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recommended for massive point projection  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **project** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) containing input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **mapset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset containing input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: name of current mapset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map to re-project  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to GRASS database of input project  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **smax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum segment length in meters in output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Increases accuracy of reprojected shapes, disable with smax=0  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10000*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map (default: input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **pipeline** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;PROJ pipeline for coordinate transformation  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *z*, *w*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List vector maps in input mapset and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume z coordinate is ellipsoidal height and transform if possible  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3D vector maps only  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable wrapping to -180,180 for latlon output  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Latlon output only, default is -180,180  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build vector topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recommended for massive point projection  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.proj* allows a user to convert a vector map in a specified mapset of
a specified project (different from current) with coordinate reference
system (CRS) of source project to the vector map in a current mapset of
current project with CRS of current project (both CRSs are defined in
their corresponding projects). The CRS information can be viewed and
managed with *[g.proj](g.proj.md)*.

For an introduction to map CRSs (and the PROJ library), see the manual
page of [r.proj](r.proj.md).

## NOTES

If **output** is not specified it is set to be the same as input map
name.  
If **mapset** is not specified, its name is assumed to be the same as
the current mapset's name.  
If **dbase** is not specified it is assumed to be the current database.
The user only has to specify **dbase** if the source project is stored
in another separate GRASS database.  
If **smax** is set to **0** the automated vertex densification is
disabled (not recommended).

*v.proj* supports general datum transformations, making use of the
*PROJ* co-ordinate system translation library.

When projecting into a latlon project, east coordinates are wrapped by
the proj4 library to fit into the range -180,180. This is in most cases
appropriate, but can cause errors the input vector crosses the datum
line at 180E/W. In this case wrapping of east coordinates to -180,180
needs to be disabled with the **-w** flag.

When reprojecting massive point clouds for which topology is not
necessary, the user can set the **-b** flag to suppress the building of
topology of the output map.

In order to preserve spatial detail, *v.proj* performs automated vertex
densification (as an alternative, *[v.split](v.split.md)* could be used
before reprojecting. Without vertex densification, depending on the
source and target CRS (Coordinate Reference System), geometries can be
substantially deformed (straight lines become curves, squares become
trapezoids, etc). The densification of linear features can help to avoid
topological errors.

## EXAMPLE

Reprojection of a vector map from another project (and mapset) into the
current mapset:

```sh
v.proj in=mymap project=latlong mapset=user1
```

## REFERENCES

1. Evenden, G.I. (1990) [Cartographic projection procedures for the
    UNIX environment - a user's manual.](https://proj.org) USGS
    Open-File Report 90-284 (OF90-284.pdf) See also there: Interim
    Report and 2nd Interim Report on Release 4, Evenden 1994).
2. Richards, John A. (1993), Remote Sensing Digital Image Analysis,
    Springer-Verlag, Berlin, 2nd edition.

[PROJ](https://proj.org): Projection/datum support library.

Further reading:

- [ASPRS Grids and
  Datum](https://www.asprs.org/asprs-publications/grids-and-datums)
- [Projections Transform List](http://geotiff.maptools.org/proj_list/)
  (PROJ)
- [Coordinate operations](https://proj.org/operations/index.html) by
  PROJ (projections, conversions, transformations, pipeline operator)
- [MapRef - The Collection of Map Projections and Reference Systems for
  Europe](https://mapref.org)
- [Information and Service System for European Coordinate Reference
  Systems - CRS](https://www.crs-geo.eu)

## SEE ALSO

*[g.proj](g.proj.md), [m.proj](m.proj.md), [r.proj](r.proj.md),
[i.rectify](i.rectify.md), [r.stats](r.stats.md),
[v.sample](v.sample.md), [v.split](v.split.md),
[v.surf.idw](v.surf.idw.md), [v.surf.rst](v.surf.rst.md)*

## AUTHORS

Irina Kosinovsky, US ARMY CERL  
M.L. Holko, USDA, SCS, NHQ-CGIS  
R.L. Glenn, USDA, SCS, NHQ-CGIS

## SOURCE CODE

Available at: [v.proj source code](https://github.com/OSGeo/grass/tree/main/vector/v.proj)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.proj))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
