---
name: r3.neighbors
description: Makes each voxel value a function of the values assigned to the voxels around it, and stores new voxel values in an output 3D raster map
keywords: [ raster3d, algebra, voxel, statistics, aggregation, neighbor, focal statistics, filter ]
---

# r3.neighbors

Makes each voxel value a function of the values assigned to the voxels around it, and stores new voxel values in an output 3D raster map

=== "Command line"

    **r3.neighbors**
    **input**=*name*
    **output**=*name*
    **method**=*string*
    [**quantile**=*float*]
    **window**=*x,y,z*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.neighbors input=name output=name method=average window=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.neighbors***",
        **input**,
        **output**,
        **method**,
        **quantile**=*None*,
        **window**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.neighbors", input="name", output="name", method="average", window=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_neighbors*(**input**,
        **output**,
        **method**,
        **quantile**=*None*,
        **window**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_neighbors(input="name", output="name", method="average", window=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, stddev, sum, count, variance, diversity, interspersion, quart1, quart3, perc90, quantile*  
    **quantile**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    **window**=*x,y,z* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of the window in x, y and z direction, values must be odd integer numbers, eg: 3,3,3  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, stddev, sum, count, variance, diversity, interspersion, quart1, quart3, perc90, quantile*  
    **quantile** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    **window** : tuple[int, int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of the window in x, y and z direction, values must be odd integer numbers, eg: 3,3,3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, stddev, sum, count, variance, diversity, interspersion, quart1, quart3, perc90, quantile*  
    **quantile** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    **window** : tuple[int, int, int] | list[int] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The size of the window in x, y and z direction, values must be odd integer numbers, eg: 3,3,3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y,z*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

***r3.neighbors*** looks at each voxel in a 3D raster input map layer,
and examines the values assigned to the voxel in a user-defined
"neighborhood" around it. It outputs a new 3D raster map in which each
voxel is assigned a value that is a (user-specified) function of the
values in that voxel's neighborhood. For example, each voxel in the
output map might be assigned a value equal to the average of the values
appearing in its 3 x 3 x 3 voxel "neighborhood" in the input map layer.

### OPTIONS

The user must specify the names of the 3D raster map layers to be used
for **input** and **output**, the **method** used to analyze
neighborhood values (i.e., the neighborhood function or operation to be
performed), and the moving **window** of the neighborhood.

*Neighborhood Operation Methods:* The **neighborhood** operators
determine what new value a center voxel in a neighborhood will have
after examining values inside its neighboring voxels. Each voxel in a 3D
raster map layer becomes the center voxel of a neighborhood as the
neighborhood window moves from voxel to voxel throughout the map layer.
***r3.neighbors*** can perform the following operations:

**average**  
The average value within the neighborhood.

**median**  
The value found half-way through a list of the neighborhood's values,
when these are ranged in numerical order.

**mode**  
The most frequently occurring value in the neighborhood.

**minimum**  
The minimum value within the neighborhood.

**maximum**  
The maximum value within the neighborhood.

**range**  
The range value within the neighborhood.

**stddev**  
The statistical standard deviation of values within the neighborhood.

**sum**  
The sum of values within the neighborhood.

**variance**  
The statistical variance of values within the neighborhood.

**diversity**  
The number of different values within the neighborhood.

**interspersion**  
The percentage of voxels containing values which differ from the values
assigned to the center voxel in the neighborhood, plus 1.

*Neighborhood Size:* The neighborhood moving **window** specifies which
voxel surrounding any given voxel fall into the neighborhood for that
voxel. The **window** must be three comma separated odd integers. The
dimension order is: x,y,z. For example: the parameter window=3,3,3
specifies a moving window (a cube) with 27 voxel.

## NOTES

The ***r3.neighbors*** program works in the current geographic region.
It is recommended, but not required, that the 3D resolution of the
geographic region be the same as that of the 3D raster map layer.

***r3.neighbors*** doesn't propagate NULLs, but computes the aggregation
over the non-NULL voxels in the neighborhood.

## SEE ALSO

*[g.region](g.region.md), [r.neighbors](r.neighbors.md),
[r3.mapcalc](r3.mapcalc.md), [r3.stats](r3.stats.md),
[r3.support](r3.support.md)*

## AUTHOR

Soeren Gebbert

## SOURCE CODE

Available at: [r3.neighbors source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.neighbors)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.neighbors))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
