---
name: r.sunmask
description: Calculates cast shadow areas from sun position and elevation raster map. Either exact sun position (A) is specified, or date/time to calculate the sun position (B) by r.sunmask itself.
keywords: [ raster, solar, sun position, shadow ]
---

# r.sunmask

Calculates cast shadow areas from sun position and elevation raster map.

Either exact sun position (A) is specified, or date/time to calculate the sun position (B) by r.sunmask itself.

=== "Command line"

    **r.sunmask**
    [**-zsg**]
    **elevation**=*name*
    [**output**=*name*]
    [**altitude**=*float*]
    [**azimuth**=*float*]
    [**year**=*integer*]
    [**month**=*integer*]
    [**day**=*integer*]
    [**hour**=*integer*]
    [**minute**=*integer*]
    [**second**=*integer*]
    [**timezone**=*integer*]
    [**east**=*value*]
    [**north**=*value*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.sunmask elevation=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.sunmask***",
        **elevation**,
        **output**=*None*,
        **altitude**=*None*,
        **azimuth**=*None*,
        **year**=*None*,
        **month**=*None*,
        **day**=*None*,
        **hour**=*None*,
        **minute**=*None*,
        **second**=*0*,
        **timezone**=*None*,
        **east**=*None*,
        **north**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.sunmask", elevation="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_sunmask*(**elevation**,
        **output**=*None*,
        **altitude**=*None*,
        **azimuth**=*None*,
        **year**=*None*,
        **month**=*None*,
        **day**=*None*,
        **hour**=*None*,
        **minute**=*None*,
        **second**=*0*,
        **timezone**=*None*,
        **east**=*None*,
        **north**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_sunmask(elevation="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **altitude**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Altitude of the sun in degrees above the horizon (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-89.999*  
    **azimuth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the sun in degrees from north (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **year**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Year (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1950-2050*  
    **month**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-12*  
    **day**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Day (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-31*  
    **hour**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hour (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **minute**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minutes (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-60*  
    **second**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seconds (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-60*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **timezone**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Timezone  
    &nbsp;&nbsp;&nbsp;&nbsp;East positive, offset from GMT, also use to adjust daylight savings  
    **east**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Easting coordinate (point of interest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: map center  
    **north**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northing coordinate (point of interest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: map center  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not ignore zero elevation  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Calculate sun position only and exit  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the sun position output in shell script style  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **altitude** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Altitude of the sun in degrees above the horizon (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-89.999*  
    **azimuth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the sun in degrees from north (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **year** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Year (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1950-2050*  
    **month** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-12*  
    **day** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Day (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-31*  
    **hour** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hour (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **minute** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minutes (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-60*  
    **second** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seconds (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-60*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **timezone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Timezone  
    &nbsp;&nbsp;&nbsp;&nbsp;East positive, offset from GMT, also use to adjust daylight savings  
    **east** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Easting coordinate (point of interest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: map center  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **north** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northing coordinate (point of interest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: map center  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*, *s*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not ignore zero elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate sun position only and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the sun position output in shell script style  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **altitude** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Altitude of the sun in degrees above the horizon (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-89.999*  
    **azimuth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the sun in degrees from north (A)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **year** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Year (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1950-2050*  
    **month** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Month (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-12*  
    **day** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Day (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-31*  
    **hour** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Hour (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **minute** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minutes (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-60*  
    **second** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seconds (B)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-60*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **timezone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Timezone  
    &nbsp;&nbsp;&nbsp;&nbsp;East positive, offset from GMT, also use to adjust daylight savings  
    **east** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Easting coordinate (point of interest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: map center  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **north** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northing coordinate (point of interest)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: map center  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*, *s*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not ignore zero elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Calculate sun position only and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the sun position output in shell script style  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.sunmask* creates an output map layer based on an input elevation
raster map layer and the position of the sun. The output map layer
contains the cast shadow areas resulting from sunlight and elevation.
The user can either specify the sun position directly or the module
calculates it from given location and date/time parameters using the
SOLPOS (Solar and Moon Position Algorithm) developed by the [National
Renewable Energy Laboratory](https://www.nrel.gov/) (NREL). SOLPOS
operates in two modes, either

- \(A\) parameters to specify the exact known position of the sun, or
- \(B\) parameters to specify the date/time for the sun position
  calculation by *r.sunmask* itself

must be used.

The module performs sunset/sunrise checks and refraction correction for
sun position calculation. Local coordinate systems are internally
transformed to latitude/longitude for the SOLPOS algorithm. Elevation is
not taken into account for sunset/sunrise calculations.

The solar zenith angle ("sun angle above horizon") is defined as the
angle between the horizon and the vertical (directly overhead or
zenith). Its values can range from 90°, when the sun is directly
overhead, to 0°, when the sun is on the horizon. Values lower than 0°
indicate that the sun is below the horizon.

The solar azimuth angle ("sun azimuth") defines the direction of the
sun. It is the angle between north and the projection of the sun's rays
onto the horizontal plane. This angle is measured in a clockwise
direction and can vary between 0° and 360°. Specifically, an azimuth of
0° means the sun is in the north, 90° in the east, 180° in the south and
270° in the west.

## NOTES

*r.sunmask* and daylight saving time: Instead of converting the local
time to GMT, the SOLPOS algorithm uses what is known as Local Standard
Time, which is generally defined as an offset from GMT. So the key is
the offset from GMT, which is the solpos Time Zone parameter. If the
user specifies clock time (different for winter and summer), s/he would
have to change the Time Zone parameter in *r.sunmask* (**timezone**
parameter) seasonally. See also [Daylight saving time by region and
country](https://en.wikipedia.org/wiki/Daylight_saving_time_by_country).

Note: In latitude/longitude projects the position coordinates pair
(east/west) has to be specified in decimal degree (not DD:MM:SS). If not
specified, the map center's coordinates will be used. Also *g.region -l*
displays the map center's coordinates in latitude/longitude (or
*g.region -c* in the actual coordinate system).

Note for module usage with the *-g* flag, when performing calculations
close to sunset/sunrise:

```sh
 [...]
 sunangleabovehorizont=0.434240
 sunrise=07:59:19
 sunset=16:25:17
 Time (07:59:02) is before sunrise (07:59:19)!
 WARNING: Nothing to calculate. Please verify settings.
 No map calculation requested. Finished.
```

In above calculation it appears to be a mistake as the program indicates
that we are before sunrise while the *sun angle above horizon* is
already positive. The reason is that *sun angle above horizon* is
calculated with correction for atmosphere refraction while *sunrise* and
*sunset* are calculated **without** correction for atmosphere
refraction. The output without *-g* flag contains related indications.

## EXAMPLE

Example for North Carolina sample data set for the calculation of sun
position angles and more:

```sh
# set the region to a place near Raleigh (NC)
g.region raster=elev_lid792_1m -p

# compute only sun position and no output map
r.sunmask -s elev_lid792_1m year=2012 month=2 \
          day=22 hour=10 minute=30 timezone=-5
Using map center coordinates: 638650.000000 220375.000000
Calculating sun position... (using solpos (V. 11 April 2001) from NREL)
2012/02/22, daynum: 53, time: 10:30:00 (decimal time: 10.500000)
long: -78.678856, lat: 35.736160, timezone: -5.000000
Solar position: sun azimuth: 143.006409, sun angle above horz. (refraction corrected): 36.233879
Sunrise time (without refraction): 06:58:11
Sunset time  (without refraction): 17:58:47

# with -g flag, useful for eval() shell function
r.sunmask -s -g elev_lid792_1m  year=2012 month=2 \
          day=22 hour=10 minute=30 timezone=-5
Using map center coordinates: 638650.000000 220375.000000
Calculating sun position... (using solpos (V. 11 April 2001) from NREL)
date=2012/02/22
daynum=53
time=10:30:00
decimaltime=10.500000
longitudine=-78.678856
latitude=35.736160
timezone=-5.000000
sunazimuth=143.006409
sunangleabovehorizon=36.233879
sunrise=06:58:11
sunset=17:58:47
```

## Acknowledgements

Acknowledgements: National Renewable Energy Laboratory for their [SOLPOS
2.0](https://www.nrel.gov/grid/solar-resource/solpos.html) sun position
algorithm.

## SEE ALSO

*[g.region](g.region.md), [r.sun](r.sun.md),
[r.sunhours](r.sunhours.md), [r.slope.aspect](r.slope.aspect.md)*

## AUTHORS

Janne Soimasuo, Finland, 1994  
update to FP by Huidae Cho, 2001  
SOLPOS algorithm feature added by Markus Neteler, 2001

## SOURCE CODE

Available at: [r.sunmask source code](https://github.com/OSGeo/grass/tree/main/raster/r.sunmask)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.sunmask))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
