---
name: r.out.vrml
description: Exports a raster map to the Virtual Reality Modeling Language (VRML).
keywords: [ raster, export, output, VRML ]
---

# r.out.vrml

Exports a raster map to the Virtual Reality Modeling Language (VRML).

=== "Command line"

    **r.out.vrml**
    **elevation**=*name*
    [**color**=*name*]
    [**exaggeration**=*float*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.vrml elevation=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.vrml***",
        **elevation**,
        **color**=*None*,
        **exaggeration**=*1.0*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.vrml", elevation="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_vrml*(**elevation**,
        **color**=*None*,
        **exaggeration**=*1.0*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_vrml(elevation="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input color map  
    **exaggeration**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical exaggeration  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output VRML file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input color map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **exaggeration** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical exaggeration  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output VRML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input color map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **exaggeration** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical exaggeration  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output VRML file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This module exports a GRASS raster map to the Virtual Reality Modeling
Language (VRML) format for 3D visualization.

This version only outputs raster maps in VRML 1.0 format. The newer VRML
2.0 format will be more efficient for geographic applications, as it
introduces an "ElevationGrid" node so that only the elevation points
will have to be written instead of the whole geometry. The vast majority
of VRML viewers currently only support VRML 1.0. If the extension "wrl"
(world) is not present in the he *output* parameter, it will be added.

## WARNING

VRML is not well suited for large geometries which can result from even
a small geographic region. Most viewers seem to bog down with more than
12,000 polygons, depending on your hardware & specific viewer. Each grid
cell results in two polygons, so a reasonable size region would be
something less than about 75x75. For improved performance and smaller
file size, leave off a color map. Since VRML is ascii text, gzip works
very well to significantly compress file size.

## NOTES

This is a preliminary release of "*r.out.vrml*". For further information
about VRML and available viewers for various platforms, see:

[VRML Virtual Reality Modeling
Language](https://www.w3.org/MarkUp/VRML/)

## BUGS

Currently the region is transformed to a unit size, so real geographic
location is lost. Side effects when working in a lat-lon project are
that besides general distortion due to projection, a very small
exaggeration factor (on order of .001) must be used to compensate for
vertical units expected to be the same as map units.

## TODO

Update to the more modern [GeoVRML format](http://www.geovrml.com/eng/),
or probably better the next generation [X3D
format](https://www.web3d.org/). See also the [Xj3D
project](https://gitlab.nps.edu/Savage/xj3d).

Future plans for this module are to allow draping of sites objects and
vector maps and using the new sites format available in floating point
GRASS to embed WWW links into site objects. It will also be upgraded to
support VRML 2.0 and will allow entering multiple preset "views" using
the existing GRASS 3d_view file format.

Other possible additions:

- Allow animation of elevation, color, or sites based on user
  interaction.
- Degradation of the raster to produce TINs for improved performance.

## AUTHOR

Bill Brown, US Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.out.vrml source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.vrml)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.vrml))  
Latest change: Sunday Jul 27 05:53:30 2025 in commit [da40958](https://github.com/OSGeo/grass/commit/da409580ef15011f3bac379c76d41101c9e36347)
