---
name: r.in.srtm.py
description: Imports SRTM HGT files into raster map.
keywords: [ raster, import, SRTM ]
---

# r.in.srtm.py

Imports SRTM HGT files into raster map.

=== "Command line"

    **r.in.srtm.py**
    [**-1**]
    **input**=*name*
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.srtm.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.srtm.py***",
        **input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.srtm.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_srtm_py*(**input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_srtm_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of SRTM input tile (file without .hgt.zip extension)  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: input tile)  
    **-1**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is a 1-arcsec tile (default: 3-arcsec)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of SRTM input tile (file without .hgt.zip extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: input tile)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1*  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input is a 1-arcsec tile (default: 3-arcsec)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of SRTM input tile (file without .hgt.zip extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map (default: input tile)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1*  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input is a 1-arcsec tile (default: 3-arcsec)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.srtm* imports SRTM HGT files into GRASS. SRTM Version 1 and
improved Version 2 data sets can be downloaded from NASA at this site:  
[http://dds.cr.usgs.gov/srtm/](https://web.archive.org/web/20200806210105/https://dds.cr.usgs.gov/srtm/)
(archived)  
<https://earthexplorer.usgs.gov/>

Gap-filled SRTM Version 3 data can be downloaded from USGS at this
site:  
<https://e4ftl01.cr.usgs.gov/MEASURES/SRTMGL3.003/2000.02.11/>

## NOTES

SRTM tiles are of 1 degree by 1 degree size. The SRTM filename contains
the coordinates which refer to the **center** of the lower left pixel
(e.g., N51E010: lower left cell center at 10E, 51N). To identify a tile
name, a grid can be easily visualized by *[d.grid](d.grid.md)*:

```sh
d.grid size=1
```

To import TOPEX/SRTM30 PLUS data, use *[r.in.bin](r.in.bin.md)*.

## REFERENCES

M. Neteler, 2005. [SRTM and VMAP0 data in OGR and
GRASS.](https://grass.osgeo.org/newsletter/GRASSNews_vol3.pdf) *[GRASS
Newsletter](https://grass.osgeo.org/newsletter/)*, Vol.3, pp. 2-6, June
2005. ISSN 1614-8746.

## SEE ALSO

*[r.in.bin](r.in.bin.md),
[r.in.srtm.region](https://grass.osgeo.org/grass8/manuals/addons/r.in.srtm.region.html)
(Addon),
[r.in.nasadem](https://grass.osgeo.org/grass8/manuals/addons/r.in.nasadem.html)
(Addon)*

The [Shuttle Radar Topography
Mission](https://web.archive.org/web/20240204072129/https://www2.jpl.nasa.gov/srtm/)
homepage at NASA's JPL. (archived)  
The [SRTM Web
Forum](https://web.archive.org/web/20071029205240/http://pub7.bravenet.com/forum/537683448/)
(archived)

## AUTHORS

Markus Neteler  
Improved by W. Kyngesburye and H. Bowman  
Update for SRTM V3 by Markus Metz

## SOURCE CODE

Available at: [r.in.srtm source code](https://github.com/OSGeo/grass/tree/main/scripts/r.in.srtm)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.in.srtm))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
