---
name: i.eb.netrad
description: Net radiation approximation (Bastiaanssen, 1995).
keywords: [ imagery, energy balance, net radiation, SEBAL ]
---

# i.eb.netrad

Net radiation approximation (Bastiaanssen, 1995).

=== "Command line"

    **i.eb.netrad**
    **albedo**=*name*
    **ndvi**=*name*
    **temperature**=*name*
    **localutctime**=*name*
    **temperaturedifference2m**=*name*
    **emissivity**=*name*
    **transmissivity_singleway**=*name*
    **dayofyear**=*name*
    **sunzenithangle**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.netrad albedo=name ndvi=name temperature=name localutctime=name temperaturedifference2m=name emissivity=name transmissivity_singleway=name dayofyear=name sunzenithangle=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.netrad***",
        **albedo**,
        **ndvi**,
        **temperature**,
        **localutctime**,
        **temperaturedifference2m**,
        **emissivity**,
        **transmissivity_singleway**,
        **dayofyear**,
        **sunzenithangle**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.netrad", albedo="name", ndvi="name", temperature="name", localutctime="name", temperaturedifference2m="name", emissivity="name", transmissivity_singleway="name", dayofyear="name", sunzenithangle="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_netrad*(**albedo**,
        **ndvi**,
        **temperature**,
        **localutctime**,
        **temperaturedifference2m**,
        **emissivity**,
        **transmissivity_singleway**,
        **dayofyear**,
        **sunzenithangle**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_netrad(albedo="name", ndvi="name", temperature="name", localutctime="name", temperaturedifference2m="name", emissivity="name", transmissivity_singleway="name", dayofyear="name", sunzenithangle="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **albedo**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of albedo raster map [0.0;1.0]  
    **ndvi**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI raster map [-1.0;+1.0]  
    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of surface temperature raster map [K]  
    **localutctime**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of time of satellite overpass raster map [local time in UTC]  
    **temperaturedifference2m**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the difference map of temperature from surface skin to about 2 m height [K]  
    **emissivity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the emissivity map [-]  
    **transmissivity_singleway**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way atmospheric transmissivitymap [-]  
    **dayofyear**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day Of Year (DOY) map [-]  
    **sunzenithangle**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the sun zenith angle map [degrees]  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output net radiation layer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **albedo** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of albedo raster map [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI raster map [-1.0;+1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of surface temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **localutctime** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of time of satellite overpass raster map [local time in UTC]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperaturedifference2m** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the difference map of temperature from surface skin to about 2 m height [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **emissivity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the emissivity map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivity_singleway** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way atmospheric transmissivitymap [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day Of Year (DOY) map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **sunzenithangle** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the sun zenith angle map [degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output net radiation layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **albedo** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of albedo raster map [0.0;1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI raster map [-1.0;+1.0]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of surface temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **localutctime** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of time of satellite overpass raster map [local time in UTC]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **temperaturedifference2m** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the difference map of temperature from surface skin to about 2 m height [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **emissivity** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the emissivity map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transmissivity_singleway** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the single-way atmospheric transmissivitymap [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Day Of Year (DOY) map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **sunzenithangle** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the sun zenith angle map [degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output net radiation layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.netrad* calculates the net radiation at the time of satellite
overpass, the way it is in the SEBAL model of Bastiaanssen (1995). It
takes input of Albedo, NDVI, Surface Skin temperature, time of satellite
overpass, surface emissivity, difference of temperature from surface
skin and about 2 m height (dT), instantaneous satellite overpass
single-way atmospheric transmissivity (tsw), Day of Year (DOY), and sun
zenith angle.

## NOTES

In the old methods, dT was taken as flat images (dT=5.0), if you don't
have a dT map from ground data, you would want to try something in this
line, this is to calculate atmospherical energy balance. In the same
way, a standard tsw is used in those equations. Refer to `r_net.c` for
that and for other non-used equations, but stored in there for further
research convenience.

## TODO

Add more explanations.

## REFERENCES

- Bastiaanssen, W.G.M., 1995. Regionalization of surface flux densities
  and moisture indicators in composite terrain; a remote sensing
  approach under clear skies in mediterranean climates. PhD thesis,
  Wageningen Agricultural Univ., The Netherland, 271 pp.
  ([PDF](https://edepot.wur.nl/206553))
- Chemin, Y., 2012. A Distributed Benchmarking Framework for Actual ET
  Models, in: Irmak, A. (Ed.), Evapotranspiration - Remote Sensing and
  Modeling. InTech. ([PDF](https://www.intechopen.com/chapters/26115))

## SEE ALSO

*[i.eb.soilheatflux](i.eb.soilheatflux.md),
[i.eb.hsebal01](i.eb.hsebal01.md), [i.albedo](i.albedo.md)*

## AUTHOR

Yann Chemin, International Rice Research Institute, The Philippines

## SOURCE CODE

Available at: [i.eb.netrad source code](https://github.com/OSGeo/grass/tree/main/imagery/i.eb.netrad)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.eb.netrad))  
Latest change: Thursday Jun 26 21:25:27 2025 in commit [3ec2b13](https://github.com/OSGeo/grass/commit/3ec2b13945d963db69544e3fc9339fbff72f33f3)
