---
name: g.gui.timeline
description: Allows comparing temporal datasets by displaying their temporal extents in a plot.
keywords: [ general, GUI, temporal, plot ]
description: wxGUI Timeline Tool
index: topic_GUI|GUI
---

# g.gui.timeline

Allows comparing temporal datasets by displaying their temporal extents in a plot.

=== "Command line"

    **g.gui.timeline**
    [**-3**]
    [**inputs**=*name* [,*name*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.timeline
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.timeline***",
        **inputs**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.timeline")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_timeline*(**inputs**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_timeline()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **inputs**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time datasets  
    **-3**  
    &nbsp;&nbsp;&nbsp;&nbsp;Show also 3D plot of spatio-temporal extents  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **inputs** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3*  
    &nbsp;&nbsp;&nbsp;&nbsp;**3**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show also 3D plot of spatio-temporal extents  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **inputs** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *3*  
    &nbsp;&nbsp;&nbsp;&nbsp;**3**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show also 3D plot of spatio-temporal extents  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

# wxGUI Timeline Tool

## DESCRIPTION

The **Timeline Tool** is a *[wxGUI](wxGUI.md)* component which allows
the user to compare the extents of temporal datasets (strds, stvds,
str3ds) in a plot.

Supported features:

- temporal datasets with interval/point and absolute/relative time
- 2D plots - temporal extent
- 3D plots - spatio-temporal extent (matplotlib \>= 1.0.0)
- pop-up annotations with basic metadata

![Timeline Tool screenshot](timeline_2D.jpg)

## NOTES

*g.gui.timeline* requires the Python plotting library
[Matplotlib](https://matplotlib.org/).

## SEE ALSO

*[Temporal data processing](temporal.md), [wxGUI](wxGUI.md), [wxGUI
components](wxGUI.components.md)*

## AUTHOR

Anna Kratochvilova, [Czech Technical University in
Prague](https://www.cvut.cz), Czech Republic

## SOURCE CODE

Available at: [g.gui.timeline source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/timeline)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/timeline))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
