---
title: Display tools
author: GRASS Development Team
---


| Name | Description |
|--------|-------------|
| [d.background](d.background.md) | Fills the graphics display frame with user defined color. |
| [d.barscale](d.barscale.md) | Displays a barscale on the graphics monitor. |
| [d.colorlist](d.colorlist.md) | Outputs a list of all available display colors. |
| [d.colortable](d.colortable.md) | Displays the color table associated with a raster map layer. |
| [d.correlate](d.correlate.md) | Prints a graph of the correlation between raster maps (in pairs). |
| [d.erase](d.erase.md) | Erases the contents of the active graphics display frame with user defined color. |
| [d.font](d.font.md) | Selects the font in which text will be displayed on the user's graphics monitor. |
| [d.fontlist](d.fontlist.md) | Lists the available fonts. |
| [d.frame](d.frame.md) | Manages display frames on the user's graphics monitor. |
| [d.geodesic](d.geodesic.md) | Displays a geodesic line, tracing the shortest distance between two geographic points along a great circle, in a longitude/latitude data set. |
| [d.graph](d.graph.md) | Program for generating and displaying simple graphics on the display monitor. |
| [d.grid](d.grid.md) | Overlays a user-specified grid in the active display frame on the graphics monitor. |
| [d.his](d.his.md) | Displays the result obtained by combining hue, intensity, and saturation (HIS) values from user-specified input raster map layers. |
| [d.histogram](d.histogram.md) | Displays a histogram in the form of a pie or bar chart for a user-specified raster map. |
| [d.info](d.info.md) | Displays information about the active display monitor. Display monitors are maintained by d.mon. |
| [d.labels](d.labels.md) | Displays text labels (created with v.label) to the active frame on the graphics monitor. |
| [d.legend](d.legend.md) | Displays a legend for a 2D or 3D raster map in the active frame of the graphics monitor. |
| [d.legend.vect](d.legend.vect.md) | Displays a vector legend in the active graphics frame. |
| [d.linegraph](d.linegraph.md) | Generates and displays simple line graphs in the active graphics monitor display frame. |
| [d.mon](d.mon.md) | Controls graphics display monitors from the command line. |
| [d.northarrow](d.northarrow.md) | Displays a north arrow on the graphics monitor. |
| [d.out.file](d.out.file.md) | Saves the contents of the active display monitor to a graphics file. |
| [d.path](d.path.md) | Finds shortest path for selected starting and ending node. |
| [d.polar](d.polar.md) | Draws polar diagram of angle map such as aspect or flow directions |
| [d.profile](d.profile.md) | Plots profile of a transect. |
| [d.rast.arrow](d.rast.arrow.md) | Draws arrows representing cell aspect direction for a raster map containing aspect data. |
| [d.rast.edit](d.rast.edit.md) | Edits cell values in a raster map. |
| [d.rast.leg](d.rast.leg.md) | Displays a raster map and its legend on a graphics window |
| [d.rast](d.rast.md) | Displays user-specified raster map in the active graphics frame. |
| [d.rast.num](d.rast.num.md) | Overlays cell category values on a raster map displayed in the active graphics frame. |
| [d.redraw](d.redraw.md) | Redraws the content of currently selected monitor. |
| [d.rgb](d.rgb.md) | Displays three user-specified raster maps as red, green, and blue overlays in the active graphics frame. |
| [d.rhumbline](d.rhumbline.md) | Displays the rhumbline joining two longitude/latitude coordinates. |
| [d.shade](d.shade.md) | Drapes a color raster over an shaded relief or aspect map. |
| [d.text](d.text.md) | Draws text in the active display frame on the graphics monitor using the current font. |
| [d.title](d.title.md) | Create a TITLE for a raster map in a form suitable for display with d.text. |
| [d.to.rast](d.to.rast.md) | Saves the contents of the active display monitor to a raster map. |
| [d.vect.chart](d.vect.chart.md) | Displays charts of vector data in the active frame on the graphics monitor. |
| [d.vect](d.vect.md) | Displays user-specified vector map in the active graphics frame. |
| [d.vect.thematic](d.vect.thematic.md) | Displays a thematic vector map in the active graphics frame. |
| [d.what.rast](d.what.rast.md) | Allows the user to interactively query raster map layers at user-selected locations. |
| [d.what.vect](d.what.vect.md) | Allows the user to interactively query vector map layers at user-selected locations. |
| [d.where](d.where.md) | Identifies the geographic coordinates associated with point locations given in display coordinates. |
