/***************************************************************************
    qgsrelationreferencefactory.h
     --------------------------------------
    Date                 : 29.5.2013
    Copyright            : (C) 2013 Matthias Kuhn
    Email                : matthias at opengis dot ch
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSRELATIONREFERENCEFACTORY_H
#define QGSRELATIONREFERENCEFACTORY_H

#include "qgsattributeeditorcontext.h"
#include "qgseditorwidgetfactory.h"
#include "qgis_gui.h"

SIP_NO_FILE

class QgsMapCanvas;
class QgsMessageBar;

/**
 * \ingroup gui
 * \class QgsRelationReferenceFactory
 * \brief Editor widget factory for relation reference widgets.
 * \note not available in Python bindings
 */
class GUI_EXPORT QgsRelationReferenceFactory : public QgsEditorWidgetFactory
{
  public:
    /**
     * Constructor for QgsRelationReferenceFactory, where \a name is a human-readable
     * name for the factory and \a icon provides a visual representation of this widget type.
     *
     * The \a canvas argument is used to interact with the main map canvas and
     * the \a messageBar argument can be used to link the widget to a QgsMessageBar
     * for providing user feedback.
     */
    QgsRelationReferenceFactory( const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar, const QIcon &icon = QIcon() );

    /**
     * Override this in your implementation.
     * Create a new editor widget wrapper. Call QgsEditorWidgetRegistry::create()
     * instead of calling this method directly.
     *
     * \param vl       The vector layer on which this widget will act
     * \param fieldIdx The field index on which this widget will act
     * \param editor   An editor widget if already existent. If NULLPTR is provided, a new widget will be created.
     * \param parent   The parent for the wrapper class and any created widget.
     *
     * \returns         A new widget wrapper
     */
    QgsEditorWidgetWrapper *create( QgsVectorLayer *vl, int fieldIdx, QWidget *editor, QWidget *parent ) const override;

    QgsSearchWidgetWrapper *createSearchWidget( QgsVectorLayer *vl, int fieldIdx, QWidget *parent ) const override;

    /**
     * Override this in your implementation.
     * Create a new configuration widget for this widget type.
     *
     * \param vl       The layer for which the widget will be created
     * \param fieldIdx The field index for which the widget will be created
     * \param parent   The parent widget of the created config widget
     *
     * \returns         A configuration widget
     */
    QgsEditorConfigWidget *configWidget( QgsVectorLayer *vl, int fieldIdx, QWidget *parent ) const override;

    QHash<const char *, int> supportedWidgetTypes() override;

    unsigned int fieldScore( const QgsVectorLayer *vl, int fieldIdx ) const override;

  private:
    QgsAttributeEditorContext mEditorContext;
    QgsMapCanvas *mCanvas = nullptr;
    QgsMessageBar *mMessageBar = nullptr;
};

#endif // QGSRELATIONREFERENCEFACTORY_H
