# The PEP 484 type hints stub file for the _server module.
#
# Generated by SIP 6.9.1


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtXml
from PyQt5 import QtNetwork
from PyQt5 import QtWidgets
from PyQt5 import QtSql
from PyQt5 import QtPrintSupport
from PyQt5 import QtPositioning
from PyQt5 import QtSerialPort
from qgis import _core

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QgsCapabilitiesCache(QtCore.QObject):

    def __init__(self, size: int) -> None: ...

    def removeCapabilitiesDocument(self, path: typing.Optional[str]) -> None: ...
    def insertCapabilitiesDocument(self, configFilePath: typing.Optional[str], key: typing.Optional[str], doc: typing.Optional[QtXml.QDomDocument]) -> None: ...
    def searchCapabilitiesDocument(self, configFilePath: typing.Optional[str], key: typing.Optional[str]) -> typing.Optional[QtXml.QDomDocument]: ...


class QgsConfigCache(QtCore.QObject):

    def __init__(self, settings: typing.Optional['QgsServerSettings']) -> None: ...

    def removeChangedEntries(self) -> None: ...
    def removeChangedEntry(self, path: typing.Optional[str]) -> None: ...
    projectRemovedFromCache: typing.ClassVar[QtCore.pyqtSignal]
    def projects(self) -> list[_core.QgsProject]: ...
    def strategyName(self) -> str: ...
    def project(self, path: typing.Optional[str], settings: typing.Optional['QgsServerSettings'] = ...) -> typing.Optional[_core.QgsProject]: ...
    def removeEntry(self, path: typing.Optional[str]) -> None: ...
    @staticmethod
    def instance() -> typing.Optional['QgsConfigCache']: ...
    @staticmethod
    def initialize(settings: typing.Optional['QgsServerSettings']) -> None: ...


class QgsServerApi(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverIface: typing.Optional['QgsServerInterface']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApi') -> None: ...

    def serverIface(self) -> typing.Optional['QgsServerInterface']: ...
    def executeRequest(self, context: 'QgsServerApiContext') -> None: ...
    def accept(self, url: QtCore.QUrl) -> bool: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerApiContext(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, apiRootPath: typing.Optional[str], request: typing.Optional['QgsServerRequest'], response: typing.Optional['QgsServerResponse'], project: typing.Optional[_core.QgsProject], serverInterface: typing.Optional['QgsServerInterface']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApiContext') -> None: ...

    def handlerPath(self) -> str: ...
    def setRequest(self, request: typing.Optional['QgsServerRequest']) -> None: ...
    def apiRootPath(self) -> str: ...
    def matchedPath(self) -> str: ...
    def serverInterface(self) -> typing.Optional['QgsServerInterface']: ...
    def setProject(self, project: typing.Optional[_core.QgsProject]) -> None: ...
    def project(self) -> typing.Optional[_core.QgsProject]: ...
    def response(self) -> typing.Optional['QgsServerResponse']: ...
    def request(self) -> typing.Optional['QgsServerRequest']: ...


class QgsServerLogger(_core.QgsMessageLogConsole):

    def __init__(self) -> None: ...

    def logMessage(self, message: typing.Optional[str], tag: typing.Optional[str], level: _core.Qgis.MessageLevel) -> None: ...
    def setLogStderr(self) -> None: ...
    def setLogFile(self, filename: typing.Optional[str] = ...) -> None: ...
    def setLogLevel(self, level: _core.Qgis.MessageLevel) -> None: ...
    def logLevel(self) -> _core.Qgis.MessageLevel: ...
    @staticmethod
    def instance() -> typing.Optional['QgsServerLogger']: ...


class QgsServerOgcApi(QgsServerApi):

    class ContentType(int):
        GEOJSON = ... # type: QgsServerOgcApi.ContentType
        OPENAPI3 = ... # type: QgsServerOgcApi.ContentType
        JSON = ... # type: QgsServerOgcApi.ContentType
        HTML = ... # type: QgsServerOgcApi.ContentType
        XML = ... # type: QgsServerOgcApi.ContentType

    class Rel(int):
        alternate = ... # type: QgsServerOgcApi.Rel
        describedBy = ... # type: QgsServerOgcApi.Rel
        collection = ... # type: QgsServerOgcApi.Rel
        item = ... # type: QgsServerOgcApi.Rel
        self = ... # type: QgsServerOgcApi.Rel
        service_desc = ... # type: QgsServerOgcApi.Rel
        service_doc = ... # type: QgsServerOgcApi.Rel
        prev = ... # type: QgsServerOgcApi.Rel
        next = ... # type: QgsServerOgcApi.Rel
        license = ... # type: QgsServerOgcApi.Rel
        items = ... # type: QgsServerOgcApi.Rel
        conformance = ... # type: QgsServerOgcApi.Rel
        data = ... # type: QgsServerOgcApi.Rel

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, serverIface: typing.Optional['QgsServerInterface'], rootPath: typing.Optional[str], name: typing.Optional[str], description: typing.Optional[str] = ..., version: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerOgcApi') -> None: ...

    @staticmethod
    def mimeType(contentType: 'QgsServerOgcApi.ContentType') -> typing.Any: ...
    @staticmethod
    def contentTypeFromExtension(extension: typing.Any) -> 'QgsServerOgcApi.ContentType': ...
    @staticmethod
    @deprecated("""""")
    def contenTypeFromExtension(extension: typing.Any) -> 'QgsServerOgcApi.ContentType': ...
    @staticmethod
    def contentTypeToExtension(ct: 'QgsServerOgcApi.ContentType') -> str: ...
    @staticmethod
    def contentTypeToStdString(ct: 'QgsServerOgcApi.ContentType') -> typing.Any: ...
    @staticmethod
    def contentTypeToString(ct: 'QgsServerOgcApi.ContentType') -> str: ...
    @staticmethod
    def relToString(rel: 'QgsServerOgcApi.Rel') -> typing.Any: ...
    @staticmethod
    def sanitizeUrl(url: QtCore.QUrl) -> QtCore.QUrl: ...
    def registerHandler(self, handler: typing.Optional['QgsServerOgcApiHandler']) -> None: ...
    def executeRequest(self, context: QgsServerApiContext) -> None: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerOgcApiHandler(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerOgcApiHandler') -> None: ...

    def setContentTypes(self, contentTypes: collections.abc.Iterable[int]) -> None: ...
    @staticmethod
    def layerFromCollectionId(context: QgsServerApiContext, collectionId: typing.Optional[str]) -> typing.Optional[_core.QgsVectorLayer]: ...
    @staticmethod
    def parentLink(url: QtCore.QUrl, levels: int = ...) -> str: ...
    def contentTypeFromRequest(self, request: typing.Optional['QgsServerRequest']) -> QgsServerOgcApi.ContentType: ...
    def staticPath(self, context: QgsServerApiContext) -> str: ...
    def templatePath(self, context: QgsServerApiContext) -> str: ...
    def href(self, context: QgsServerApiContext, extraPath: typing.Optional[str] = ..., extension: typing.Optional[str] = ...) -> typing.Any: ...
    def write(self, data: typing.Any, context: QgsServerApiContext, htmlMetadata: dict[str, typing.Any] = ...) -> None: ...
    def contentTypeForAccept(self, accept: typing.Optional[str]) -> str: ...
    def values(self, context: QgsServerApiContext) -> dict[str, typing.Any]: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...
    def defaultContentType(self) -> QgsServerOgcApi.ContentType: ...
    def tags(self) -> list[str]: ...
    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> typing.Any: ...
    def description(self) -> typing.Any: ...
    def summary(self) -> typing.Any: ...
    def parameters(self, context: QgsServerApiContext) -> list['QgsServerQueryStringParameter']: ...
    def operationId(self) -> typing.Any: ...
    def path(self) -> QtCore.QRegularExpression: ...


class QgsServerStaticHandler(QgsServerOgcApiHandler):

    @typing.overload
    def __init__(self, pathRegExp: typing.Optional[str] = ..., staticPathSuffix: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerStaticHandler') -> None: ...

    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> typing.Any: ...
    def description(self) -> typing.Any: ...
    def summary(self) -> typing.Any: ...
    def operationId(self) -> typing.Any: ...
    def path(self) -> QtCore.QRegularExpression: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...


class QgsServerParameterDefinition(PyQt5.sip.wrapper):

    mDefaultValue = ... # type: typing.Any
    mType = ... # type: QtCore.QMetaType.Type
    mValue = ... # type: typing.Any

    @typing.overload
    def __init__(self, type: QtCore.QMetaType.Type = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, type: QtCore.QVariant.Type, defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameterDefinition') -> None: ...

    @staticmethod
    def raiseError(msg: typing.Optional[str]) -> None: ...
    def loadUrl(self) -> typing.Tuple[str, bool]: ...
    def toUrl(self) -> typing.Tuple[QtCore.QUrl, bool]: ...
    def toColor(self) -> typing.Tuple[QtGui.QColor, bool]: ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> typing.Tuple[float, bool]: ...
    def toInt(self) -> typing.Tuple[int, bool]: ...
    def toRectangle(self) -> typing.Tuple[_core.QgsRectangle, bool]: ...
    def toExpressionList(self) -> list[str]: ...
    def toOgcFilterList(self) -> list[str]: ...
    def toGeomList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[_core.QgsGeometry], bool]: ...
    def toColorList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[QtGui.QColor], bool]: ...
    def toDoubleList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[float], bool]: ...
    def toIntList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[int], bool]: ...
    def toStringList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> list[str]: ...
    def toString(self, defaultValue: bool = ...) -> str: ...
    def isValid(self) -> bool: ...
    def typeName(self) -> str: ...


class QgsServerParameter(QgsServerParameterDefinition):

    class Name(int):
        UNKNOWN = ... # type: QgsServerParameter.Name
        SERVICE = ... # type: QgsServerParameter.Name
        VERSION_SERVICE = ... # type: QgsServerParameter.Name
        REQUEST = ... # type: QgsServerParameter.Name
        MAP = ... # type: QgsServerParameter.Name
        FILE_NAME = ... # type: QgsServerParameter.Name

    mName = ... # type: 'QgsServerParameter.Name'
    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: 'QgsServerParameter.Name' = ..., type: QtCore.QMetaType.Type = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, name: 'QgsServerParameter.Name', type: QtCore.QVariant.Type, defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameter') -> None: ...

    @typing.overload
    @staticmethod
    def name(name: 'QgsServerParameter.Name') -> str: ...
    @typing.overload
    @staticmethod
    def name(name: typing.Optional[str]) -> 'QgsServerParameter.Name': ...
    def raiseError(self) -> None: ...


class QgsServerParameters(PyQt5.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, query: QtCore.QUrlQuery) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameters') -> None: ...

    def loadParameter(self, name: typing.Optional[str], value: typing.Optional[str]) -> bool: ...
    def version(self) -> str: ...
    def fileName(self) -> str: ...
    def map(self) -> str: ...
    def request(self) -> str: ...
    def service(self) -> str: ...
    def toMap(self) -> dict[str, str]: ...
    def urlQuery(self) -> QtCore.QUrlQuery: ...
    def value(self, key: typing.Optional[str]) -> str: ...
    @typing.overload
    def remove(self, key: typing.Optional[str]) -> None: ...
    @typing.overload
    def remove(self, name: QgsServerParameter.Name) -> None: ...
    def add(self, key: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def clear(self) -> None: ...
    def load(self, query: QtCore.QUrlQuery) -> None: ...


class QgsServerFeatureId(PyQt5.sip.simplewrapper):

    def pkSeparator(self) -> str: ...
    def getExpressionFromServerFid(self, serverFid: typing.Optional[str], provider: typing.Optional[_core.QgsVectorDataProvider]) -> str: ...
    def updateFeatureRequestFromServerFids(self, featureRequest: _core.QgsFeatureRequest, serverFids: collections.abc.Iterable[typing.Optional[str]], provider: typing.Optional[_core.QgsVectorDataProvider]) -> _core.QgsFeatureRequest: ...
    def getServerFid(self, feature: _core.QgsFeature, pkAttributes: collections.abc.Iterable[int]) -> str: ...


class QgsServerQueryStringParameter(PyQt5.sip.wrapper):

    class Type(int):
        String = ... # type: QgsServerQueryStringParameter.Type
        Integer = ... # type: QgsServerQueryStringParameter.Type
        Double = ... # type: QgsServerQueryStringParameter.Type
        Boolean = ... # type: QgsServerQueryStringParameter.Type
        List = ... # type: QgsServerQueryStringParameter.Type

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: typing.Optional[str], required: bool = ..., type: 'QgsServerQueryStringParameter.Type' = ..., description: typing.Optional[str] = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerQueryStringParameter') -> None: ...

    def setHidden(self, hidden: bool) -> None: ...
    def hidden(self) -> bool: ...
    def setDescription(self, description: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...
    @staticmethod
    def typeName(type: 'QgsServerQueryStringParameter.Type') -> str: ...
    def description(self) -> str: ...
    def value(self, context: QgsServerApiContext) -> typing.Any: ...


class QgsServerSettingsEnv(QtCore.QObject):

    class EnvVar(int):
        QGIS_OPTIONS_PATH = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PARALLEL_RENDERING = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_MAX_THREADS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_LEVEL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_FILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_STDERR = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_PROJECT_FILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_IGNORE_BAD_LAYERS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CACHE_DIRECTORY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CACHE_SIZE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_SHOW_GROUP_SEPARATOR = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_OVERRIDE_SYSTEM_LOCALE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_MAX_HEIGHT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_MAX_WIDTH = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_API_RESOURCES_DIRECTORY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_API_WFS3_MAX_LIMIT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_TRUST_LAYER_METADATA = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_FORCE_READONLY_LAYERS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_DISABLE_GETPRINT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PROJECTS_DIRECTORIES = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PROJECTS_PG_CONNECTIONS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_PROFILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WFS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WCS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMTS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PREFIX = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_CHECK_INTERVAL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_STRATEGY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_ALLOWED_EXTRA_SQL_TOKENS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_APPLICATION_NAME = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CAPABILITIES_CACHE_SIZE = ... # type: QgsServerSettingsEnv.EnvVar

    class Source(int):
        DEFAULT_VALUE = ... # type: QgsServerSettingsEnv.Source
        ENVIRONMENT_VARIABLE = ... # type: QgsServerSettingsEnv.Source
        INI_FILE = ... # type: QgsServerSettingsEnv.Source

    def __init__(self) -> None: ...


class QgsServerSettings(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerSettings') -> None: ...

    def capabilitiesCacheSize(self) -> int: ...
    @staticmethod
    def name(env: QgsServerSettingsEnv.EnvVar) -> str: ...
    def applicationName(self) -> str: ...
    def allowedExtraSqlTokens(self) -> list[str]: ...
    def projectCacheStrategy(self) -> str: ...
    def projectCacheCheckInterval(self) -> int: ...
    def serviceUrl(self, service: typing.Optional[str]) -> str: ...
    def getPrintDisabled(self) -> bool: ...
    def forceReadOnlyLayers(self) -> bool: ...
    def trustLayerMetadata(self) -> bool: ...
    def ignoreBadLayers(self) -> bool: ...
    def apiWfs3MaxLimit(self) -> int: ...
    def apiResourcesDirectory(self) -> str: ...
    def landingPageBaseUrlPrefix(self) -> str: ...
    def landingPageProjectsPgConnections(self) -> str: ...
    def landingPageProjectsDirectories(self) -> str: ...
    def wmsMaxWidth(self) -> int: ...
    def wmsMaxHeight(self) -> int: ...
    def showGroupSeparator(self) -> bool: ...
    def overrideSystemLocale(self) -> str: ...
    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def logStderr(self) -> bool: ...
    def logFile(self) -> str: ...
    def projectFile(self) -> str: ...
    def logProfile(self) -> bool: ...
    def logLevel(self) -> _core.Qgis.MessageLevel: ...
    def maxThreads(self) -> int: ...
    def parallelRendering(self) -> bool: ...
    def iniFile(self) -> str: ...
    def logSummary(self) -> None: ...
    @typing.overload
    def load(self) -> None: ...
    @typing.overload
    def load(self, envVarName: typing.Optional[str]) -> bool: ...


class QgsServiceModule(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServiceModule') -> None: ...

    def registerSelf(self, registry: 'QgsServiceRegistry', serverIface: typing.Optional['QgsServerInterface'] = ...) -> None: ...


class QgsServerRequest(PyQt5.sip.wrapper):

    class RequestHeader(int):
        HOST = ... # type: QgsServerRequest.RequestHeader
        FORWARDED = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_FOR = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_HOST = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_PROTO = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WMS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WFS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WCS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WMTS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        ACCEPT = ... # type: QgsServerRequest.RequestHeader
        USER_AGENT = ... # type: QgsServerRequest.RequestHeader
        AUTHORIZATION = ... # type: QgsServerRequest.RequestHeader

    class Method(int):
        HeadMethod = ... # type: QgsServerRequest.Method
        PutMethod = ... # type: QgsServerRequest.Method
        GetMethod = ... # type: QgsServerRequest.Method
        PostMethod = ... # type: QgsServerRequest.Method
        DeleteMethod = ... # type: QgsServerRequest.Method
        PatchMethod = ... # type: QgsServerRequest.Method

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, url: typing.Optional[str], method: 'QgsServerRequest.Method' = ..., headers: dict[typing.Optional[str], typing.Optional[str]] = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, method: 'QgsServerRequest.Method' = ..., headers: dict[typing.Optional[str], typing.Optional[str]] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsServerRequest') -> None: ...

    def setBaseUrl(self, url: QtCore.QUrl) -> None: ...
    def setOriginalUrl(self, url: QtCore.QUrl) -> None: ...
    def queryParameter(self, name: typing.Optional[str], defaultValue: typing.Optional[str] = ...) -> str: ...
    def setMethod(self, method: 'QgsServerRequest.Method') -> None: ...
    def baseUrl(self) -> QtCore.QUrl: ...
    def originalUrl(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def removeHeader(self, name: typing.Optional[str]) -> None: ...
    def headers(self) -> dict[str, str]: ...
    def setHeader(self, name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    @typing.overload
    def header(self, name: typing.Optional[str]) -> str: ...
    @typing.overload
    def header(self, headerEnum: 'QgsServerRequest.RequestHeader') -> str: ...
    def removeParameter(self, key: typing.Optional[str]) -> None: ...
    def parameter(self, key: typing.Optional[str], defaultValue: typing.Optional[str] = ...) -> str: ...
    def setParameter(self, key: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def serverParameters(self) -> QgsServerParameters: ...
    def parameters(self) -> dict[str, str]: ...
    def method(self) -> 'QgsServerRequest.Method': ...
    def url(self) -> QtCore.QUrl: ...
    @staticmethod
    def methodToString(method: 'QgsServerRequest.Method') -> str: ...


class QgsBufferServerRequest(QgsServerRequest):

    @typing.overload
    def __init__(self, url: typing.Optional[str], method: QgsServerRequest.Method = ..., headers: dict[typing.Optional[str], typing.Optional[str]] = ..., data: typing.Optional[typing.Union[QtCore.QByteArray, bytes, bytearray]] = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, method: QgsServerRequest.Method = ..., headers: dict[typing.Optional[str], typing.Optional[str]] = ..., data: typing.Optional[typing.Union[QtCore.QByteArray, bytes, bytearray]] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBufferServerRequest') -> None: ...

    def data(self) -> QtCore.QByteArray: ...


class QgsServerResponse(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerResponse') -> None: ...

    def feedback(self) -> typing.Optional[_core.QgsFeedback]: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> typing.Optional[QtCore.QIODevice]: ...
    @typing.overload
    def write(self, data: typing.Optional[str]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @typing.overload
    def write(self, ex: 'QgsServerException') -> None: ...
    def sendError(self, code: int, message: typing.Optional[str]) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> dict[str, str]: ...
    def header(self, key: typing.Optional[str]) -> str: ...
    def removeHeader(self, key: typing.Optional[str]) -> None: ...
    def setHeader(self, key: typing.Optional[str], value: typing.Optional[str]) -> None: ...


class QgsBufferServerResponse(QgsServerResponse):

    def __init__(self) -> None: ...

    def body(self) -> QtCore.QByteArray: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> typing.Optional[QtCore.QIODevice]: ...
    def sendError(self, code: int, message: typing.Optional[str]) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> dict[str, str]: ...
    def header(self, key: typing.Optional[str]) -> str: ...
    def removeHeader(self, key: typing.Optional[str]) -> None: ...
    def setHeader(self, key: typing.Optional[str], value: typing.Optional[str]) -> None: ...


class QgsFcgiServerRequest(QgsServerRequest):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFcgiServerRequest') -> None: ...

    def header(self, name: typing.Optional[str]) -> str: ...
    def hasError(self) -> bool: ...
    def data(self) -> QtCore.QByteArray: ...


class QgsRequestHandler(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, request: QgsServerRequest, response: QgsServerResponse) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRequestHandler') -> None: ...

    def headersSent(self) -> bool: ...
    def format(self) -> str: ...
    def removeParameter(self, key: typing.Optional[str]) -> None: ...
    def parameter(self, key: typing.Optional[str]) -> str: ...
    def setParameter(self, key: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def parameterMap(self) -> dict[str, str]: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def path(self) -> str: ...
    def url(self) -> str: ...
    def data(self) -> QtCore.QByteArray: ...
    def body(self) -> QtCore.QByteArray: ...
    def clearBody(self) -> None: ...
    def exceptionRaised(self) -> bool: ...
    def appendBody(self, body: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def clear(self) -> None: ...
    def requestHeaders(self) -> dict[str, str]: ...
    def requestHeader(self, name: typing.Optional[str]) -> str: ...
    def removeRequestHeader(self, name: typing.Optional[str]) -> None: ...
    def setRequestHeader(self, name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def responseHeaders(self) -> dict[str, str]: ...
    def responseHeader(self, name: typing.Optional[str]) -> str: ...
    def removeResponseHeader(self, name: typing.Optional[str]) -> None: ...
    def setResponseHeader(self, name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def sendResponse(self) -> None: ...
    def setServiceException(self, ex: 'QgsServerException') -> None: ...


class QgsServer(PyQt5.sip.wrapper):

    def __init__(self) -> None: ...

    def initPython(self) -> None: ...
    def serverInterface(self) -> typing.Optional['QgsServerInterface']: ...
    def handleRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: typing.Optional[_core.QgsProject] = ...) -> None: ...
    def putenv(self, var: typing.Optional[str], val: typing.Optional[str]) -> None: ...


class QgsServerApiUtils(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApiUtils') -> None: ...

    @staticmethod
    def appendMapParameter(path: typing.Optional[str], requestUrl: QtCore.QUrl) -> str: ...
    @staticmethod
    @deprecated("""""")
    def crsToOgcUri(crs: _core.QgsCoordinateReferenceSystem) -> str: ...
    @staticmethod
    def publishedCrsList(project: typing.Optional[_core.QgsProject]) -> list[str]: ...
    @staticmethod
    def sanitizedFieldValue(value: typing.Optional[str]) -> str: ...
    @staticmethod
    def publishedWfsLayers(context: QgsServerApiContext) -> list[_core.QgsVectorLayer]: ...
    @staticmethod
    def parseCrs(bboxCrs: typing.Optional[str]) -> _core.QgsCoordinateReferenceSystem: ...
    @staticmethod
    def temporalExtent(layer: typing.Optional[_core.QgsVectorLayer]) -> list[typing.Any]: ...
    @staticmethod
    def temporalFilterExpression(layer: typing.Optional[_core.QgsVectorLayer], interval: typing.Optional[str]) -> _core.QgsExpression: ...
    @staticmethod
    def fieldName(name: typing.Optional[str], layer: typing.Optional[_core.QgsVectorLayer]) -> str: ...
    @staticmethod
    def parseTemporalDateTimeInterval(interval: typing.Optional[str]) -> _core.QgsDateTimeRange: ...
    @staticmethod
    def parseTemporalDateInterval(interval: typing.Optional[str]) -> _core.QgsDateRange: ...
    @staticmethod
    def temporalDimensions(layer: typing.Optional[_core.QgsVectorLayer]) -> list[_core.QgsServerWmsDimensionProperties.WmsDimensionInfo]: ...
    @staticmethod
    def parseBbox(bbox: typing.Optional[str]) -> _core.QgsRectangle: ...


class QgsServerException(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, message: typing.Optional[str], responseCode: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerException') -> None: ...

    def formatResponse(self) -> typing.Tuple[QtCore.QByteArray, str]: ...
    def responseCode(self) -> int: ...


class QgsOgcServiceException(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, code: typing.Optional[str], message: typing.Optional[str], locator: typing.Optional[str] = ..., responseCode: int = ..., version: typing.Optional[str] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOgcServiceException') -> None: ...

    def formatResponse(self) -> typing.Tuple[QtCore.QByteArray, str]: ...
    def version(self) -> str: ...
    def locator(self) -> str: ...
    def code(self) -> str: ...
    def message(self) -> str: ...


class QgsServerFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverInterface: typing.Optional['QgsServerInterface']) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerFilter') -> None: ...

    def onSendResponse(self) -> bool: ...
    def onResponseComplete(self) -> bool: ...
    def onProjectReady(self) -> bool: ...
    def onRequestReady(self) -> bool: ...
    @deprecated("""""")
    def sendResponse(self) -> None: ...
    @deprecated("""""")
    def responseComplete(self) -> None: ...
    @deprecated("""""")
    def requestReady(self) -> None: ...
    def serverInterface(self) -> typing.Optional['QgsServerInterface']: ...


class QgsServerInterface(PyQt5.sip.wrapper):

    def __init__(self, a0: 'QgsServerInterface') -> None: ...

    def reloadSettings(self) -> None: ...
    def serviceRegistry(self) -> typing.Optional['QgsServiceRegistry']: ...
    def removeConfigCacheEntry(self, path: typing.Optional[str]) -> None: ...
    def setConfigFilePath(self, configFilePath: typing.Optional[str]) -> None: ...
    def configFilePath(self) -> str: ...
    def getEnv(self, name: typing.Optional[str]) -> str: ...
    def cacheManager(self) -> typing.Optional['QgsServerCacheManager']: ...
    def registerServerCache(self, serverCache: typing.Optional['QgsServerCacheFilter'], priority: int = ...) -> None: ...
    def accessControls(self) -> typing.Optional['QgsAccessControl']: ...
    def registerAccessControl(self, accessControl: typing.Optional['QgsAccessControlFilter'], priority: int = ...) -> None: ...
    def filters(self) -> typing.Any: ...
    def setFilters(self, filters: typing.Optional[typing.Any]) -> None: ...
    def registerFilter(self, filter: typing.Optional[QgsServerFilter], priority: int = ...) -> None: ...
    def requestHandler(self) -> typing.Optional[QgsRequestHandler]: ...
    def capabilitiesCache(self) -> typing.Optional[QgsCapabilitiesCache]: ...


class QgsServerProjectUtils(PyQt5.sip.simplewrapper):

    def serviceUrl(self, service: typing.Optional[str], request: QgsServerRequest, settings: QgsServerSettings) -> str: ...
    def wmtsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wcsLayerIds(self, project: _core.QgsProject) -> list[str]: ...
    def wcsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wfstDeleteLayerIds(self, project: _core.QgsProject) -> list[str]: ...
    def wfstInsertLayerIds(self, project: _core.QgsProject) -> list[str]: ...
    def wfstUpdateLayerIds(self, project: _core.QgsProject) -> list[str]: ...
    def wfsLayerPrecision(self, project: _core.QgsProject, layerId: typing.Optional[str]) -> int: ...
    def wfsLayerIds(self, project: _core.QgsProject) -> list[str]: ...
    def wfsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wmsExtent(self, project: _core.QgsProject) -> _core.QgsRectangle: ...
    def wmsOutputCrsList(self, project: _core.QgsProject) -> list[str]: ...
    def wmsRestrictedLayers(self, project: _core.QgsProject) -> list[str]: ...
    def wmsRootName(self, project: _core.QgsProject) -> str: ...
    def wmsServiceUrl(self, project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wmsRestrictedComposers(self, project: _core.QgsProject) -> list[str]: ...
    def wmsInspireMetadataDate(self, project: _core.QgsProject) -> str: ...
    def wmsInspireTemporalReference(self, project: _core.QgsProject) -> str: ...
    def wmsInspireMetadataUrlType(self, project: _core.QgsProject) -> str: ...
    def wmsInspireMetadataUrl(self, project: _core.QgsProject) -> str: ...
    def wmsInspireLanguage(self, project: _core.QgsProject) -> str: ...
    def wmsInspireActivate(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoLayerAliasMap(self, project: _core.QgsProject) -> dict[str, str]: ...
    def wmsFeatureInfoSchema(self, project: _core.QgsProject) -> str: ...
    def wmsFeatureInfoDocumentElementNs(self, project: _core.QgsProject) -> str: ...
    def wmsFeatureInfoDocumentElement(self, project: _core.QgsProject) -> str: ...
    def wmsFeatureInfoPrecision(self, project: _core.QgsProject) -> int: ...
    def wmsSkipNameForGroup(self, project: _core.QgsProject) -> bool: ...
    def wmsAddLegendGroupsLegendGraphic(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoSegmentizeWktGeometry(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoUseAttributeFormSettings(self, project: _core.QgsProject) -> bool: ...
    def wmsFeatureInfoAddWktGeometry(self, project: _core.QgsProject) -> bool: ...
    def wmsInfoFormatSia2045(self, project: _core.QgsProject) -> bool: ...
    def wmsUseLayerIds(self, project: _core.QgsProject) -> bool: ...
    def wmsDefaultMapUnitsPerMm(self, project: _core.QgsProject) -> float: ...
    def wmsMaxAtlasFeatures(self, project: _core.QgsProject) -> int: ...
    def wmsRenderMapTiles(self, project: _core.QgsProject) -> bool: ...
    def wmsTileBuffer(self, project: _core.QgsProject) -> int: ...
    def wmsImageQuality(self, project: _core.QgsProject) -> int: ...
    def wmsMaxHeight(self, project: _core.QgsProject) -> int: ...
    def wmsMaxWidth(self, project: _core.QgsProject) -> int: ...
    def owsServiceAccessConstraints(self, project: _core.QgsProject) -> str: ...
    def owsServiceFees(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactPhone(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactMail(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactPerson(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactPosition(self, project: _core.QgsProject) -> str: ...
    def owsServiceContactOrganization(self, project: _core.QgsProject) -> str: ...
    def owsServiceOnlineResource(self, project: _core.QgsProject) -> str: ...
    def owsServiceKeywords(self, project: _core.QgsProject) -> list[str]: ...
    def owsServiceAbstract(self, project: _core.QgsProject) -> str: ...
    def owsServiceTitle(self, project: _core.QgsProject) -> str: ...
    def owsServiceCapabilities(self, project: _core.QgsProject) -> bool: ...


class QgsService(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsService') -> None: ...

    def executeRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: typing.Optional[_core.QgsProject]) -> None: ...
    def version(self) -> str: ...
    def name(self) -> str: ...


class QgsServiceRegistry(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServiceRegistry') -> None: ...

    def cleanUp(self) -> None: ...
    def init(self, nativeModulepath: typing.Optional[str], serverIface: typing.Optional[QgsServerInterface] = ...) -> None: ...
    def unregisterService(self, name: typing.Optional[str], version: typing.Optional[str] = ...) -> int: ...
    def getApi(self, name: typing.Optional[str], version: typing.Optional[str] = ...) -> typing.Optional[QgsServerApi]: ...
    def unregisterApi(self, name: typing.Optional[str], version: typing.Optional[str] = ...) -> int: ...
    def registerApi(self, api: typing.Optional[QgsServerApi]) -> bool: ...
    def registerService(self, service: typing.Optional[QgsService]) -> None: ...
    def getService(self, name: typing.Optional[str], version: typing.Optional[str] = ...) -> typing.Optional[QgsService]: ...


class QgsFeatureFilterProviderGroup(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilterProviderGroup') -> None: ...

    def addProvider(self, provider: typing.Optional[_core.QgsFeatureFilterProvider]) -> 'QgsFeatureFilterProviderGroup': ...
    def clone(self) -> typing.Optional[_core.QgsFeatureFilterProvider]: ...
    def layerAttributes(self, layer: typing.Optional[_core.QgsVectorLayer], attributes: collections.abc.Iterable[typing.Optional[str]]) -> list[str]: ...
    def filterFeatures(self, layer: typing.Optional[_core.QgsVectorLayer], filterFeatures: _core.QgsFeatureRequest) -> None: ...


class QgsFeatureFilter(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilter') -> None: ...

    def setFilter(self, layer: typing.Optional[_core.QgsVectorLayer], expression: _core.QgsExpression) -> None: ...
    def clone(self) -> typing.Optional[_core.QgsFeatureFilterProvider]: ...
    def layerAttributes(self, layer: typing.Optional[_core.QgsVectorLayer], attributes: collections.abc.Iterable[typing.Optional[str]]) -> list[str]: ...
    def filterFeatures(self, layer: typing.Optional[_core.QgsVectorLayer], filterFeatures: _core.QgsFeatureRequest) -> None: ...


class QgsStoreBadLayerInfo(_core.QgsProjectBadLayerHandler):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStoreBadLayerInfo') -> None: ...

    def badLayerNames(self) -> dict[str, str]: ...
    def badLayers(self) -> list[str]: ...
    def handleBadLayers(self, layers: collections.abc.Iterable[QtXml.QDomNode]) -> None: ...


class QgsAccessControlFilter(PyQt5.sip.wrapper):

    class LayerPermissions(PyQt5.sip.wrapper):

        canDelete = ... # type: bool
        canInsert = ... # type: bool
        canRead = ... # type: bool
        canUpdate = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAccessControlFilter.LayerPermissions') -> None: ...

    @typing.overload
    def __init__(self, serverInterface: typing.Optional[QgsServerInterface]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAccessControlFilter') -> None: ...

    def cacheKey(self) -> str: ...
    def allowToEdit(self, layer: typing.Optional[_core.QgsVectorLayer], feature: _core.QgsFeature) -> bool: ...
    def authorizedLayerAttributes(self, layer: typing.Optional[_core.QgsVectorLayer], attributes: collections.abc.Iterable[typing.Optional[str]]) -> list[str]: ...
    def layerPermissions(self, layer: typing.Optional[_core.QgsMapLayer]) -> 'QgsAccessControlFilter.LayerPermissions': ...
    def layerFilterSubsetString(self, layer: typing.Optional[_core.QgsVectorLayer]) -> str: ...
    def layerFilterExpression(self, layer: typing.Optional[_core.QgsVectorLayer]) -> str: ...
    def serverInterface(self) -> typing.Optional[QgsServerInterface]: ...


class QgsAccessControl(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, copy: 'QgsAccessControl') -> None: ...

    def registerAccessControl(self, accessControl: typing.Optional[QgsAccessControlFilter], priority: int = ...) -> None: ...
    def fillCacheKey(self, cacheKey: collections.abc.Iterable[typing.Optional[str]]) -> bool: ...
    def allowToEdit(self, layer: typing.Optional[_core.QgsVectorLayer], feature: _core.QgsFeature) -> bool: ...
    def layerAttributes(self, layer: typing.Optional[_core.QgsVectorLayer], attributes: collections.abc.Iterable[typing.Optional[str]]) -> list[str]: ...
    def layerDeletePermission(self, layer: typing.Optional[_core.QgsVectorLayer]) -> bool: ...
    def layerUpdatePermission(self, layer: typing.Optional[_core.QgsVectorLayer]) -> bool: ...
    def layerInsertPermission(self, layer: typing.Optional[_core.QgsVectorLayer]) -> bool: ...
    def layerReadPermission(self, layer: typing.Optional[_core.QgsMapLayer]) -> bool: ...
    def extraSubsetString(self, layer: typing.Optional[_core.QgsVectorLayer]) -> str: ...
    def clone(self) -> typing.Optional[_core.QgsFeatureFilterProvider]: ...
    def filterFeatures(self, layer: typing.Optional[_core.QgsVectorLayer], filterFeatures: _core.QgsFeatureRequest) -> None: ...
    def unresolveFilterFeatures(self) -> None: ...
    def resolveFilterFeatures(self, layers: collections.abc.Iterable[_core.QgsMapLayer]) -> None: ...


class QgsServerCacheFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverInterface: typing.Optional[QgsServerInterface]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerCacheFilter') -> None: ...

    def deleteCachedImages(self, project: typing.Optional[_core.QgsProject]) -> bool: ...
    def deleteCachedImage(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, key: typing.Optional[str]) -> bool: ...
    def setCachedImage(self, img: typing.Optional[typing.Union[QtCore.QByteArray, bytes, bytearray]], project: typing.Optional[_core.QgsProject], request: QgsServerRequest, key: typing.Optional[str]) -> bool: ...
    def getCachedImage(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, key: typing.Optional[str]) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: typing.Optional[_core.QgsProject]) -> bool: ...
    def deleteCachedDocument(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, key: typing.Optional[str]) -> bool: ...
    def setCachedDocument(self, doc: typing.Optional[QtXml.QDomDocument], project: typing.Optional[_core.QgsProject], request: QgsServerRequest, key: typing.Optional[str]) -> bool: ...
    def getCachedDocument(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, key: typing.Optional[str]) -> QtCore.QByteArray: ...


class QgsServerCacheManager(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, settings: QgsServerSettings = ...) -> None: ...
    @typing.overload
    def __init__(self, copy: 'QgsServerCacheManager') -> None: ...

    def registerServerCache(self, serverCache: typing.Optional[QgsServerCacheFilter], priority: int = ...) -> None: ...
    def deleteCachedImages(self, project: typing.Optional[_core.QgsProject]) -> bool: ...
    def deleteCachedImage(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, accessControl: typing.Optional[QgsAccessControl]) -> bool: ...
    def setCachedImage(self, img: typing.Optional[typing.Union[QtCore.QByteArray, bytes, bytearray]], project: typing.Optional[_core.QgsProject], request: QgsServerRequest, accessControl: typing.Optional[QgsAccessControl]) -> bool: ...
    def getCachedImage(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, accessControl: typing.Optional[QgsAccessControl]) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: typing.Optional[_core.QgsProject]) -> bool: ...
    def deleteCachedDocument(self, project: typing.Optional[_core.QgsProject], request: QgsServerRequest, accessControl: typing.Optional[QgsAccessControl]) -> bool: ...
    def setCachedDocument(self, doc: typing.Optional[QtXml.QDomDocument], project: typing.Optional[_core.QgsProject], request: QgsServerRequest, accessControl: typing.Optional[QgsAccessControl]) -> bool: ...
    def getCachedDocument(self, doc: typing.Optional[QtXml.QDomDocument], project: typing.Optional[_core.QgsProject], request: QgsServerRequest, accessControl: typing.Optional[QgsAccessControl]) -> bool: ...
