---
name: v.reclass
description: Changes vector category values for an existing vector map according to results of SQL queries or a value in attribute table column.
keywords: [ vector, reclassification, attributes ]
---

# v.reclass

Changes vector category values for an existing vector map according to results of SQL queries or a value in attribute table column.

=== "Command line"

    **v.reclass**
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**column**=*name*]
    [**rules**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.reclass input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.reclass***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid"*,
        **output**,
        **column**=*None*,
        **rules**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.reclass", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_reclass*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid"*,
        **output**,
        **column**=*None*,
        **rules**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_reclass(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the column whose values are to be used as new categories  
    &nbsp;&nbsp;&nbsp;&nbsp;The source for the new key column must be type integer or string  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to the reclass rule file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the column whose values are to be used as new categories  
    &nbsp;&nbsp;&nbsp;&nbsp;The source for the new key column must be type integer or string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to the reclass rule file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the column whose values are to be used as new categories  
    &nbsp;&nbsp;&nbsp;&nbsp;The source for the new key column must be type integer or string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rules** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to the reclass rule file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.reclass* allows user to create a new vector map based on the
reclassification of an existing vector map. It also allows the user to
change the *key column* away from the default of "**cat**" with the
**column** option.

Rules file may contain on each row either pair:

```sh
keyword value
```

(separated by space) or comment beginning with '#' (hash). Definition of
new category begins with keyword *cat* followed by the new category
value. Keyword *where* specifies SQL where condition.

## NOTES

No table is created for the reclassed map if the **column** option is
used and the column type is integer (as the result could contain
ambiguities). If the **column** option is used and the column type is
string, a new table is created containing the newly generated cat
numbers and a single column containing the unique string column values,
sorted in alphabetical order.

For dissolving common boundaries, see *[v.dissolve](v.dissolve.md)*.

Either the **rules** or **column** option must be specified.

## EXAMPLES

### Example 1: Reclass by rules

```sh
v.reclass input=land output=land_u type=boundary rules=land.rcl
```

The rules file contains:

```sh
# land reclass file
cat 1
where use = 'E13' and owner = 'Jara Cimrman'
cat 2
where use = 'E14'
```

Produces a new vector area map *land_u* containing boundaries from
*land* with area category values selected from database by SQL select
statement:  
`select id from tland where use = 'E13' and owner = 'Jara Cimrman'`
changed to category 1;  
values selected from database by SQL select statement:  
`select id from tland where use = 'E14'` changed to category 2.

### Example 2: Reclass by attribute column

(North Carolina sample dataset)  

```sh
v.reclass in=streams out=streams_by_type column=I_vs_P

v.db.select streams_by_type
cat|I_vs_P
1|intermittent
2|perennial
```

## KNOWN ISSUES

No table is created for reclassed layer if the **rules** option is used.

## SEE ALSO

*[v.dissolve](v.dissolve.md), [v.extract](v.extract.md)*

*[GRASS SQL interface](sql.md)*

## AUTHORS

R.L. Glenn, USDA, SCS, NHQ-CGIS  
from v.reclass to v.db.reclass and later to v.reclass in 5.7 rewritten
by Radim Blazek

## SOURCE CODE

Available at: [v.reclass source code](https://github.com/OSGeo/grass/tree/main/vector/v.reclass)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.reclass))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
