---
name: r.stats.zonal
description: Calculates category or object oriented statistics (accumulator-based statistics).
keywords: [ raster, statistics, zonal statistics ]
---

# r.stats.zonal

Calculates category or object oriented statistics (accumulator-based statistics).

=== "Command line"

    **r.stats.zonal**
    [**-cr**]
    **base**=*name*
    **cover**=*name*
    **method**=*string*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.stats.zonal base=name cover=name method=count output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.stats.zonal***",
        **base**,
        **cover**,
        **method**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.stats.zonal", base="name", cover="name", method="count", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_stats_zonal*(**base**,
        **cover**,
        **method**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_stats_zonal(base="name", cover="name", method="count", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **base**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    **cover**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of object-based statistic  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *count, sum, min, max, range, average, avedev, variance, stddev, skewness, kurtosis, variance2, stddev2, skewness2, kurtosis2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**count**: Count of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**range**: Range of values (max - min) in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**average**: Average of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**avedev**: Average deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewness of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis**: Kurtosis of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance2**: (2-pass) Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev2**: (2-pass) Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness2**: (2-pass) Skewness of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis2**: (2-pass) Kurtosis of values in specified objects  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cover values extracted from the category labels of the cover map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create reclass map with statistics as category labels  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **base** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cover** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of object-based statistic  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *count, sum, min, max, range, average, avedev, variance, stddev, skewness, kurtosis, variance2, stddev2, skewness2, kurtosis2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**count**: Count of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**range**: Range of values (max - min) in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**average**: Average of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**avedev**: Average deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewness of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis**: Kurtosis of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance2**: (2-pass) Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev2**: (2-pass) Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness2**: (2-pass) Skewness of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis2**: (2-pass) Kurtosis of values in specified objects  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cover values extracted from the category labels of the cover map  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create reclass map with statistics as category labels  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **base** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of base raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **cover** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of cover raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method of object-based statistic  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *count, sum, min, max, range, average, avedev, variance, stddev, skewness, kurtosis, variance2, stddev2, skewness2, kurtosis2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**count**: Count of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**range**: Range of values (max - min) in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**average**: Average of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**avedev**: Average deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewness of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis**: Kurtosis of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance2**: (2-pass) Variance of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev2**: (2-pass) Standard deviation of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness2**: (2-pass) Skewness of values in specified objects  
    &nbsp;&nbsp;&nbsp;&nbsp;**kurtosis2**: (2-pass) Kurtosis of values in specified objects  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Cover values extracted from the category labels of the cover map  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create reclass map with statistics as category labels  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.stats.zonal* is a tool to analyse exploratory statistics of a
floating-point "cover layer" according to how it intersects with objects
in a "base layer". A variety of standard statistical measures are
possible. This type of analysis is often called *zonal statistics*. The
zones are specified as the **base** raster map and the statistics are
computed from cells in the **cover** raster map. Notably, the output of
this module is spatial: The resulting values are recorded as cell values
in the **output** raster map.

## NOTES

*r.stats.zonal* is intended to be a partial replacement for
*[r.statistics](r.statistics.md)*, with support for floating-point cover
maps at the expense of not supporting quantiles. For this, see
*[r.stats.quantile](r.stats.quantile.md)*.

## EXAMPLE

In this example, the raster polygon map `zipcodes` in the North Carolina
sample dataset is used to calculate zonal raster statistics using the
`elevation` raster map:

```sh
g.region raster=zipcodes -p

# pixel count in zipcode areas
r.stats.zonal base=zipcodes cover=elevation method=count output=zipcodes_elev_count
r.colors zipcodes_elev_count color=gyr -g

# average elevation in zipcode areas
r.stats.zonal base=zipcodes cover=elevation method=average output=zipcodes_elev_avg
r.colors zipcodes_elev_avg color=elevation -g
```

![Zonal (average) elevation statistics](r_stats.zonal.png)  
  
*Figure: ZIP code map on the left shows ZIP code areas, elevation map
the respective values per pixel, zonal statistics map on the right shows
the average elevation per zone (all maps: spatial subset).*

## SEE ALSO

- *[r.stats.quantile](r.stats.quantile.md)* for computing quantiles in
  zones (objects in base raster map),
- *[r.quantile](r.quantile.md)* for computing quantiles of a whole
  raster map,
- *[r.statistics](r.statistics.md)* for categorical (integer) zonal
  statistics,
- *[r.univar](r.univar.md)* for zonal statistics with textual
  (non-spatial) output,
- *[v.vect.stats](v.vect.stats.md)* for statistics of vector points in
  vector areas.

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.stats.zonal source code](https://github.com/OSGeo/grass/tree/main/raster/r.stats.zonal)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.stats.zonal))  
Latest change: Wednesday May 21 09:11:03 2025 in commit [4510205](https://github.com/OSGeo/grass/commit/45102055f4f205276ad5f85b5775b70c6583a26f)
