---
name: m.measure
description: Measures the lengths and areas of features.
keywords: [ miscellaneous, measurement, distance, area ]
---

# m.measure

Measures the lengths and areas of features.

=== "Command line"

    **m.measure**
    [**-g**]
    **coordinates**=*east,north* [,*east,north*,...]
    [**units**=*string*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    m.measure coordinates=0.0 format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***m.measure***",
        **coordinates**,
        **units**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("m.measure", coordinates=0.0, format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.m_measure*(**coordinates**,
        **units**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.m_measure(coordinates=0.0, format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **coordinates**=*east,north* [,*east,north*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: project map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: project map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: project map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*m.measure* provides the user with a way to measure the lengths and
areas of lines and polygons. Areas can be stated in acres, hectares,
square miles, square feet, square meters and square kilometers.

## EXAMPLES

Distance example in a latitude-longitude coordinate reference system (on
great circle, i.e. an orthodrome):

```sh
Bonn_DE="7.09549,50.73438"
Philadelphia_US="-75.16379,39.95233"

m.measure coordinates="$Bonn_DE,$Philadelphia_US" units=kilometers
Length:  6217.916452 kilometers
```

![Visualization (with d.geodesic) of m.measure distance example](m_measure_distance.png)  
*Visualization (with d.geodesic) of m.measure
distance example*

As an example for the North Carolina sample dataset, here four points
describing a square of 1000m side length:

```sh
m.measure units=meters \
  coordinates=922000,2106000,923000,2106000,923000,2107000,922000,2107000
Length:  3000.000000 meters
Area:    1000000.000000 square meters

# script style output:
m.measure -g units=hectares \
  coordinates=922000,2106000,923000,2106000,923000,2107000,922000,2107000
units=meters,square meters
length=3000.000000
area=1000000.000000
```

Measuring length and area using Python (JSON output):

```python
import grass.script as gs

data = gs.parse_command(
    "m.measure",
    coordinates=[
        "922000",
        "2106000",
        "923000",
        "2106000",
        "923000",
        "2107000",
        "922000",
        "2107000",
    ],
    format="json",
)
print(data)
```

Possible output:

```text
{'units': {'length': 'meters', 'area': 'square meters'}, 'length': 3000, 'area': 1000000}
```

## SEE ALSO

*[d.geodesic](d.geodesic.md)*

## AUTHORS

Glynn Clements  
Some updates by Martin Landa, CTU in Prague, Czech Republic  
  
Derived from d.measure by James Westervelt, Michael Shapiro, U.S. Army
Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [m.measure source code](https://github.com/OSGeo/grass/tree/main/misc/m.measure)
([history](https://github.com/OSGeo/grass/commits/main/misc/m.measure))  
Latest change: Monday Nov 03 07:16:48 2025 in commit [c967967](https://github.com/OSGeo/grass/commit/c96796774942e46bbababcd652d3986d4e295665)
