---
name: i.ortho.elev
description: Select or modify the target elevation model.
keywords: [ imagery, orthorectify ]
---

# i.ortho.elev

Select or modify the target elevation model.

=== "Command line"

    **i.ortho.elev**
    [**-p**]
    **group**=*name*
    [**project**=*name*]
    [**mapset**=*name*]
    [**elevation**=*name*]
    [**math_expression**=*string*]
    [**units**=*string*]
    [**null_value**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.ortho.elev group=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.ortho.elev***",
        **group**,
        **project**=*None*,
        **mapset**=*None*,
        **elevation**=*None*,
        **math_expression**=*None*,
        **units**=*None*,
        **null_value**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.ortho.elev", group="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_ortho_elev*(**group**,
        **project**=*None*,
        **mapset**=*None*,
        **elevation**=*None*,
        **math_expression**=*None*,
        **units**=*None*,
        **null_value**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_ortho_elev(group="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group for ortho-rectification  
    **project**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the target project (location)  
    **mapset**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the target mapset  
    **elevation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation map to use for ortho-rectification  
    **math_expression**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Math expression to convert to real elevation  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unit of the elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;No data value  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print currently selected elevation map and exit  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the target project (location)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **mapset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the target mapset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **elevation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation map to use for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **math_expression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Math expression to convert to real elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unit of the elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;No data value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print currently selected elevation map and exit  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery group for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the target project (location)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **mapset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the target mapset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **elevation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation map to use for ortho-rectification  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **math_expression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Math expression to convert to real elevation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Unit of the elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;No data value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print currently selected elevation map and exit  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.ortho.elev* is used to select or modify the target elevation model
for orthorectification of imagery. This elevation model is essential for
both the computation of photo-to-target parameters and for the actual
orthorectification of imagery group files. The elevation model selected
should cover the entire area of the image group to be orthorectified.
Optionally, scaled elevation data can be converted to real elevation
values specifying a mathematical expression.

## SEE ALSO

*[i.ortho.photo](i.ortho.photo.md)  
[i.ortho.camera](i.ortho.camera.md)  
[g.gui.photo2image](g.gui.photo2image.md)  
[g.gui.image2target](g.gui.image2target.md)  
[i.ortho.init](i.ortho.init.md)  
[i.rectify](i.rectify.md)*

## AUTHORS

Mike Baba, DBA Systems, Inc.  
Bugfixes and enhancements for GRASS GIS 7 by Markus Metz

## SOURCE CODE

Available at: [i.ortho.elev source code](https://github.com/OSGeo/grass/tree/main/imagery/i.ortho.photo/i.ortho.elev)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.ortho.photo/i.ortho.elev))  
Latest change: Monday Jun 09 20:45:43 2025 in commit [e2e9b35](https://github.com/OSGeo/grass/commit/e2e9b358ee8fc51a2cd5fd8c20ea084537b6e29e)
