---
name: v.class
description: Classifies attribute data, e.g. for thematic mapping
keywords: [ vector, classification, attribute table, statistics ]
---

# v.class

Classifies attribute data, e.g. for thematic mapping

=== "Command line"

    **v.class**
    [**-b**]
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**where**=*sql_query*]
    **algorithm**=*string*
    **nbclasses**=*integer*
    [**separator**=*character*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.class map=name column=name algorithm=int nbclasses=0 format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.class***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **where**=*None*,
        **algorithm**,
        **nbclasses**,
        **separator**=*"comma"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.class", map="name", column="name", algorithm="int", nbclasses=0, format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_class*(**map**,
        **layer**=*"1"*,
        **column**,
        **where**=*None*,
        **algorithm**,
        **nbclasses**,
        **separator**=*"comma"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_class(map="name", column="name", algorithm="int", nbclasses=0, format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name or expression  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **algorithm**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm to use for classification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, std, qua, equ, dis*  
    &nbsp;&nbsp;&nbsp;&nbsp;**int**: simple intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;**std**: standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;**qua**: quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**equ**: equiprobable (normal distribution)  
    &nbsp;&nbsp;&nbsp;&nbsp;**dis**: discontinuities  
    **nbclasses**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes to define  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for printing output  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json, list*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**list**: List of class breaks values  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print only class breaks (without min and max)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name or expression  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **algorithm** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm to use for classification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, std, qua, equ, dis*  
    &nbsp;&nbsp;&nbsp;&nbsp;**int**: simple intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;**std**: standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;**qua**: quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**equ**: equiprobable (normal distribution)  
    &nbsp;&nbsp;&nbsp;&nbsp;**dis**: discontinuities  
    **nbclasses** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes to define  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for printing output  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json, list*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**list**: List of class breaks values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print only class breaks (without min and max)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name or expression  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **algorithm** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm to use for classification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, std, qua, equ, dis*  
    &nbsp;&nbsp;&nbsp;&nbsp;**int**: simple intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;**std**: standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;**qua**: quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**equ**: equiprobable (normal distribution)  
    &nbsp;&nbsp;&nbsp;&nbsp;**dis**: discontinuities  
    **nbclasses** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes to define  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for printing output  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json, list*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**list**: List of class breaks values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print only class breaks (without min and max)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.class* classifies vector attribute data into classes, for example for
thematic mapping. Classification can be on a column or on an expression
including several columns, all in the table linked to the vector map.
The user indicates the number of classes desired and the algorithm to
use for classification. Several algorithms are implemented for
classification: equal interval, standard deviation, quantiles, equal
probabilities, and a discontinuities algorithm developed by Jean-Pierre
Grimmeau at the Free University of Brussels (ULB). It can be used to
pipe class breaks into thematic mapping modules such as
*d.vect.thematic* (see example below);

## NOTES

The *equal interval* algorithm simply divides the range max-min by the
number of breaks to determine the interval between class breaks.

The *quantiles* algorithm creates classes which all contain
approximately the same number of observations.

The *standard deviations* algorithm creates class breaks which are a
combination of the mean +/- the standard deviation. It calculates a
scale factor (\<1) by which to multiply the standard deviation in order
for all of the class breaks to fall into the range min-max of the data
values.

The *equiprobabilites* algorithm creates classes that would be
equiprobable if the distribution was normal. If some of the class breaks
fall outside the range min-max of the data values, the algorithm prints
a warning and reduces the number of breaks, but the probabilities used
are those of the number of breaks asked for.

The *discont* algorithm systematically searches discontinuities in the
slope of the cumulative frequencies curve, by approximating this curve
through straight line segments whose vertices define the class breaks.
The first approximation is a straight line which links the two end nodes
of the curve. This line is then replaced by a two-segmented polyline
whose central node is the point on the curve which is farthest from the
preceding straight line. The point on the curve furthest from this new
polyline is then chosen as a new node to create break up one of the two
preceding segments, and so forth.

The problem of the difference in terms of units between the two axes is
solved by rescaling both amplitudes to an interval between 0 and 1. In
the original algorithm, the process is stopped when the difference
between the slopes of the two new segments is no longer significant
(alpha = 0.05). As the slope is the ratio between the frequency and the
amplitude of the corresponding interval, i.e. its density, this
effectively tests whether the frequencies of the two newly proposed
classes are different from those obtained by simply distributing the sum
of their frequencies amongst them in proportion to the class amplitudes.
In the GRASS implementation, the algorithm continues, but a warning is
printed.

The **-g** flag has been renamed to the **-b** flag. Please use the **-b**
flag to print class breaks. Support for using the **-g** flag for class
breaks is deprecated and will be removed in a future release.

## EXAMPLE

Classify column pop of map communes into 5 classes using quantiles:

```sh
v.class map=communes column=pop algo=qua nbclasses=5
```

This example uses population and area to calculate a population density
and to determine the density classes:

```sh
v.class map=communes column=pop/area algo=std nbclasses=5
```

The following example uses the output of v.class and feeds it directly
into *d.vect.thematic*:

```sh
d.vect.thematic -l map=communes2 column=pop/area \
    breaks=`v.class -b map=communes2 column=pop/area algo=std nbcla=5` \
    colors=0:0:255,50:100:255,255:100:50,255:0:0,156:0:0
```

This example classifies attribute in map bridges by YEAR_BUILT using the
standard deviations and outputs data in CSV format:

```sh
v.class map=bridges column=YEAR_BUILT algorithm=std nbclasses=5 format=csv
```

Possible output:

```text
from,to,frequency
1891.00000,1938.82969,750
1938.82969,1954.72284,1841
1954.72284,1970.61598,5556
1970.61598,1986.50913,1788
1986.50913,1997.00000,1003
```

This example classifies attribute in map bridges by YEAR_BUILT using the standard
deviations and uses pandas to output data:

```python
import pandas as pd
import grass.script as gs

data = gs.parse_command(
    "v.class",
    map="bridges",
    column="YEAR_BUILT",
    algorithm="std",
    nbclasses=5,
    format="json",
)

df = pd.DataFrame(data["intervals"])
print(df)
```

Possible output:

```text
          from           to  frequency
0  1891.000000  1938.829689        750
1  1938.829689  1954.722836       1841
2  1954.722836  1970.615983       5556
3  1970.615983  1986.509130       1788
4  1986.509130  1997.000000       1003
```

The JSON output looks like:

```json
{
    "classes": 5,
    "mean": 1962.6694093984274,
    "standard_deviation": 15.893146881275285,
    "breaks": [
        1938.8296890765146,
        1954.7228359577898,
        1970.6159828390651,
        1986.5091297203403
    ],
    "intervals": [
        {
            "from": 1891,
            "to": 1938.8296890765146,
            "frequency": 750
        },
        {
            "from": 1938.8296890765146,
            "to": 1954.7228359577898,
            "frequency": 1841
        },
        {
            "from": 1954.7228359577898,
            "to": 1970.6159828390651,
            "frequency": 5556
        },
        {
            "from": 1970.6159828390651,
            "to": 1986.5091297203403,
            "frequency": 1788
        },
        {
            "from": 1986.5091297203403,
            "to": 1997,
            "frequency": 1003
        }
    ]
}
```

## SEE ALSO

*[v.univar](v.univar.md), [d.vect.thematic](d.vect.thematic.md)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [v.class source code](https://github.com/OSGeo/grass/tree/main/vector/v.class)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.class))  
Latest change: Saturday Oct 11 04:38:40 2025 in commit [3dd71f5](https://github.com/OSGeo/grass/commit/3dd71f5fab83b72a2db2da959fe075c5b3b52200)
