---
name: r.shade.py
description: Drapes a color raster over an shaded relief or aspect map.
keywords: [ raster, elevation, relief, hillshade, visualization ]
---

# r.shade.py

Drapes a color raster over an shaded relief or aspect map.

=== "Command line"

    **r.shade.py**
    [**-c**]
    **shade**=*name*
    **color**=*name*
    **output**=*name*
    [**brighten**=*integer*]
    [**bgcolor**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.shade.py shade=name color=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.shade.py***",
        **shade**,
        **color**,
        **output**,
        **brighten**=*0*,
        **bgcolor**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.shade.py", shade="name", color="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_shade_py*(**shade**,
        **color**,
        **output**,
        **brighten**=*0*,
        **bgcolor**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_shade_py(shade="name", color="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **shade**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded relief or aspect raster map  
    **color**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to drape over relief raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically, this raster is elevation or other colorful raster  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded raster map  
    **brighten**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent to brighten  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color to use instead of NULL values  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use colors from color tables for NULL values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **shade** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded relief or aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to drape over relief raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically, this raster is elevation or other colorful raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **brighten** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent to brighten  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color to use instead of NULL values  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use colors from color tables for NULL values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **shade** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded relief or aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to drape over relief raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically, this raster is elevation or other colorful raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **brighten** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent to brighten  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color to use instead of NULL values  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use colors from color tables for NULL values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.shade* will drape a color raster map over a shaded relief map. In
place of shaded relief, any raster map can be used including aspect or
slope. The color raster map is usually an elevation raster map with
colorful color table (as opposed to gray scale color table). However,
any raster map can be used including categorical raster maps. The result
is a raster map created from elevation and the shade raster.

Comparing to creating shaded relief as semi-transparent overlay on the
color raster map, this module gives result with more saturated colors.

The input for this module can be created for example using
*[r.slope.aspect](r.slope.aspect.md)* or *[r.relief](r.relief.md)*.

NULL values are propagated by default, so if any of the two input
rasters contains NULL cell NULL will be also in the output. If **-c**
flag is used and cell in **color** raster is NULL, just **shade** color
is used. If cell in **shade** raster is NULL, shading effect is not
applied and original colors are used. If **bgcolor** option is used,
NULL value in any input raster will be in the output replaced by the
given color.

## NOTES

Refer to the *[r.his](r.his.md)* help page for more details; *r.shade*
is a frontend to that module with addition of brightness support similar
to one provided by *[d.shade](d.shade.md)*. However, note that the
brightness is not implemenented in the same way as for
*[d.shade](d.shade.md)* and the results might be different. *r.shade* is
using method described in *[r.his](r.his.md)* manual page.

## EXAMPLES

In this example, the `aspect` map in the North Carolina sample dataset
is used to hillshade the `elevation` map:

```sh
g.region raster=aspect -p
r.shade shade=aspect color=elevation output=elevation_aspect_shaded

d.mon wx0
d.rast elevation_aspect_shaded
```

In this next example, a shaded relief raster map is created and used to
create a colorized hillshade raster map for later use:

```sh
g.region raster=elevation
r.relief input=elevation output=elevation_shaded_relief

r.shade shade=elevation_shaded_relief color=elevation \
    output=elevation_relief_shaded

d.mon wx1
d.rast elevation_relief_shaded
```

Interesting visualizations can be created using different color tables
for elevation raster map, for example using `haxby` color table.

![Elevation with shaded relief (hillshade)](rshade.png)

Figure: A detail of raster created by applying shading effect of shaded
relief (hillshade) to elevation raster map from North Carolina dataset
elevation map

## SEE ALSO

*[r.his](r.his.md), [d.his](d.his.md), [d.shade](d.shade.md),
[g.pnmcomp](g.pnmcomp.md), [r.slope.aspect](r.slope.aspect.md),
[r.relief](r.relief.md)*

## AUTHORS

Hamish Bowman  
Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)  
Inspired by *[d.shade](d.shade.md)* and manual for *[r.his](r.his.md)*.

## SOURCE CODE

Available at: [r.shade source code](https://github.com/OSGeo/grass/tree/main/scripts/r.shade)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.shade))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
