---
name: d.geodesic
description: Displays a geodesic line, tracing the shortest distance between two geographic points along a great circle, in a longitude/latitude data set.
keywords: [ display, distance, great circle, shortest path ]
---

# d.geodesic

Displays a geodesic line, tracing the shortest distance between two geographic points along a great circle, in a longitude/latitude data set.

=== "Command line"

    **d.geodesic**
    **coordinates**=*lon1,lat1,lon2,lat2*
    [**line_color**=*name*]
    [**text_color**=*name*]
    [**units**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.geodesic coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.geodesic***",
        **coordinates**,
        **line_color**=*"black"*,
        **text_color**=*None*,
        **units**=*"meters"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.geodesic", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_geodesic*(**coordinates**,
        **line_color**=*"black"*,
        **text_color**=*None*,
        **units**=*"meters"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_geodesic(coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **coordinates**=*lon1,lat1,lon2,lat2* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting and ending coordinates  
    **line_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *meters*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **coordinates** : tuple[float, float, float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting and ending coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *lon1,lat1,lon2,lat2*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *meters*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **coordinates** : tuple[float, float, float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting and ending coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *lon1,lat1,lon2,lat2*  
    **line_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *meters, kilometers, feet, miles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *meters*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.geodesic* displays a geodesic line in the active frame on the user's
graphics monitor. This is also known as the great circle line and traces
the shortest distance between two user-specified points on the curved
surface of a longitude/latitude data set. The two coordinate locations
named must fall within the boundaries of the user's current geographic
region.

## OPTIONS

By default black line color and red text color will be used.

By indicating the starting and ending coordinates of the geodesic, the
line and its length (by default in meters) are displayed to the
graphical output. If the text color is set to *none*, the great circle
distance is not displayed.

## EXAMPLE

A geodesic line if shown over the political map of the world
(demolocation dataset):

```sh
g.region vector=country_boundaries -p
d.mon wx0
d.vect country_boundaries type=area
# show additionally a 20 degree grid
d.grid 20

d.geodesic coordinates=55:58W,33:18S,26:43E,60:37N \
  line_color=yellow text_color=red units=kilometers
```

![Geodesic line (great circle line)](d_geodesic.png)  
*Geodesic line (great circle line)*

## NOTES

This program works only with longitude/latitude coordinate system.

## SEE ALSO

*[d.rhumbline](d.rhumbline.md), [d.grid](d.grid.md),
[m.measure](m.measure.md)*

## AUTHOR

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.geodesic source code](https://github.com/OSGeo/grass/tree/main/display/d.geodesic)
([history](https://github.com/OSGeo/grass/commits/main/display/d.geodesic))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
