---
name: d.frame.py
description: Manages display frames on the user's graphics monitor.
keywords: [ display, graphics, monitors, frame ]
---

# d.frame.py

Manages display frames on the user's graphics monitor.

=== "Command line"

    **d.frame.py**
    [**-cepa**]
    **frame**=*name*
    [**at**=*bottom,top,left,right*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.frame.py frame=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.frame.py***",
        **frame**,
        **at**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.frame.py", frame="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_frame_py*(**frame**,
        **at**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_frame_py(frame="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **frame**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Frame to be selected or created (if -c flag is given)  
    **at**=*bottom,top,left,right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates in percent where to place the frame (0,0 is lower-left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Implies only when -c or --overwrite flag is given  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new frame if doesn't exist and select  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove all frames, erase the screen and exit  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print name of current frame and exit  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print names of all frames including 'at' position and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **frame** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Frame to be selected or created (if -c flag is given)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **at** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates in percent where to place the frame (0,0 is lower-left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Implies only when -c or --overwrite flag is given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *bottom,top,left,right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *e*, *p*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a new frame if doesn't exist and select  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all frames, erase the screen and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print name of current frame and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print names of all frames including 'at' position and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **frame** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Frame to be selected or created (if -c flag is given)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **at** : tuple[float, float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen coordinates in percent where to place the frame (0,0 is lower-left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Implies only when -c or --overwrite flag is given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *bottom,top,left,right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *e*, *p*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a new frame if doesn't exist and select  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all frames, erase the screen and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print name of current frame and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print names of all frames including 'at' position and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.frame* manages display frames on the current user's graphics monitor.
Graphics are displayed in rectangular frames on whatever graphics
monitor the user is currently directing GRASS display output to (defined
by *[d.mon](d.mon.md)* module). These frames are created and managed
with this module.

Note that GRASS frame contents *are not* retained when one frame covers
another. You cannot shuffle frames from top to bottom and then back
again. They simply define rectangular areas on the screen where
subsequent drawing will occur.

## NOTES

The coordinates for the **at** option are stated in the form
*top,bottom,left,right* values are in percent. The upper-left corner of
the graphics monitor always is at location 0,0 while the monitor's
lower-right corner is always at 100,100.

If the user has created multiple display frames that overlap one
another, whatever the user displays in the active frame will overwrite
those portions of the underlying frame where these frames overlap.

## EXAMPLE

```sh
# start a new graphics monitor, the data will be rendered to
# /tmp/map.png image output file of size 600x540px
d.mon cairo out=/tmp/map.png width=600 height=540 --o

# set up region
g.region raster=elevation

# remove all frames and erase the current graphics monitor
d.frame -e

# create a first frame and display 'landuse96_28m' raster map including text label
# order: bottom,top,left,right - in percent
d.frame -c frame=first at=0,50,0,50
d.rast landuse96_28m
d.text text='Landuse' bgcolor=220:220:220 color=black size=6

# create a second frame and display 'streams' vector map
d.frame -c frame=second at=0,50,50,100
d.vect streams color=blue
d.text text='Streams' bgcolor=220:220:220 color=black size=6

# create a third frame and display 'elevation' raster map including text label and scale
d.frame -c frame=third at=50,100,0,50
d.rast elevation
d.text text='Elevation' bgcolor=220:220:220 color=black size=6
d.barscale at=0,10 style=line bgcolor=none

# create a fourth frame and display RGB composition map including text label
d.frame -c frame=fourth at=50,100,50,100
d.rgb red=lsat7_2002_30 green=lsat7_2002_20 blue=lsat7_2002_10
d.text text='RGB true colors' bgcolor=220:220:220 color=black size=6

# release the current graphics monitor
d.mon -r
```

![d.frame example](d_frame.png)  
*Figure: d.frame example*

## SEE ALSO

*[d.erase](d.erase.md), [d.info](d.info.md), [d.mon](d.mon.md),
[d.redraw](d.redraw.md)*

[GRASS environment variables for
rendering](variables.md#list-of-selected-grass-environment-variables-for-rendering)
(GRASS_RENDER_FRAME)

## AUTHORS

Martin Landa, Czech Technical University in Prague, Czech Republic

Based on *d.frame* from GRASS 6:  
James Westervelt, U.S. Army Construction Engineering Research
Laboratory  
Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.frame source code](https://github.com/OSGeo/grass/tree/main/scripts/d.frame)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.frame))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
