---
name: d.correlate.py
description: Prints a graph of the correlation between raster maps (in pairs).
keywords: [ display, statistics, raster, diagram, correlation ]
---

# d.correlate.py

Prints a graph of the correlation between raster maps (in pairs).

=== "Command line"

    **d.correlate.py**
    **map**=*name* [,*name*,...]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.correlate.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.correlate.py***",
        **map**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.correlate.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_correlate_py*(**map**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_correlate_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.correlate* displays graphically the results of a *r.stats* analysis
run on two raster map layers. This module highlights the correlation (or
lack of it) among data layers (scattergram).

The results are displayed in the active display frame on the user's
graphics monitor. *d.correlate* erases the active frame before
displaying results. If no graphics monitor is open, a file `map.png` is
generated in the current directory.

## NOTES

If three or four map layers are specified, the correlation among each
combination of two data layers is displayed.

## EXAMPLE

Scatterplot of two LANDSAT TM7 channels (North Carolina sample dataset):

```sh
g.region raster=lsat7_2002_30 -p
d.correlate map=lsat7_2002_30,lsat7_2002_40
```

![Scatterplot of two LANDSAT TM7 channels](d_correlate_plot.png)  
*Scatterplot of two LANDSAT TM7 channels*

## SEE ALSO

*[d.text](d.text.md), [d.graph](d.graph.md), [r.coin](r.coin.md),
[r.regression.line](r.regression.line.md), [r.stats](r.stats.md)*

## AUTHORS

Michael Shapiro, [U.S.Army Construction Engineering Research
Laboratory](http://www.cecer.army.mil/)

Rewritten to GRASS 6 (from csh to sh) by Markus Neteler; from sh to
Python by Glynn Clements

## SOURCE CODE

Available at: [d.correlate source code](https://github.com/OSGeo/grass/tree/main/scripts/d.correlate)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.correlate))  
Latest change: Wednesday Feb 12 23:02:46 2025 in commit [9c11460](https://github.com/OSGeo/grass/commit/9c1146064f7c3c21fb0746063fa8bd2cdf4633cb)
