---
name: v.lrs.segment
description: Creates points/segments from input lines, linear reference system and positions read from stdin or a file.
keywords: [ vector, linear reference system, network ]
---

# v.lrs.segment

Creates points/segments from input lines, linear reference system and positions read from stdin or a file.

=== "Command line"

    **v.lrs.segment**
    **input**=*name*
    **output**=*name*
    [**llayer**=*string*]
    [**rsdriver**=*string*]
    [**rsdatabase**=*string*]
    **rstable**=*string*
    [**file**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.lrs.segment input=name output=name rstable=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.lrs.segment***",
        **input**,
        **output**,
        **llayer**=*"1"*,
        **rsdriver**=*"sqlite"*,
        **rsdatabase**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **rstable**,
        **file**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.lrs.segment", input="name", output="name", rstable="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_lrs_segment*(**input**,
        **output**,
        **llayer**=*"1"*,
        **rsdriver**=*"sqlite"*,
        **rsdatabase**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **rstable**,
        **file**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_lrs_segment(input="name", output="name", rstable="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map where segments will be written  
    **llayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing segment rules. If not given, read from stdin.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map where segments will be written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **llayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing segment rules. If not given, read from stdin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map where segments will be written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **llayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing segment rules. If not given, read from stdin.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.lrs.segment* creates points/segments from input lines, linear
reference system and positions read from `standard in` or a file.

The format is as follows:  

```sh
P <point_id> <line_id> <milepost>+<offset> [<side offset>]
L <segment_id> <line_id> <milepost>+<offset> <milepost>+<offset> [<side offset>]
```

## NOTES

For more information and examples see the help page for
*v.lrs.segment*'s sister module, *[v.segment](v.segment.md)*.

## EXAMPLE

This example is written for the Spearfish dataset (it continues the
example from *v.lrs.create*).

In this example, the 'route_lrs' shall be extended for a new position
(point) along the LRS after bus stop 4:

```sh
# new point on LRS
echo "P 7 22 4+180" | v.lrs.segment route_lrs out=route_lrs_new rstable=route_lrs

g.region vector=route_lrs n=n+100 s=s-100 -p
d.erase
# existing LRS
d.vect route_lrs
d.vect busstops disp=attr attr=cat size=10 bg=white lcol=blue yref=bottom
d.vect busstops icon=basic/circle fcol=blue
db.select table=route_lrs

# show modified map
d.vect route_lrs_new col=red
```

## TODO

Figure out how to merge result into existing LRS map and table.

## SEE ALSO

*[v.lrs.create](v.lrs.create.md), [v.lrs.where](v.lrs.where.md),
[v.lrs.label](v.lrs.label.md), [v.segment](v.segment.md)*

*[LRS tutorial](lrs.md),  
[Introducing the Linear Reference System in
GRASS](https://foss4g.asia/2004/Full-Paper_PDF/Introducing-the-Linear-Reference-System-in-GRASS.pdf)*

## AUTHOR

Radim Blazek

## SOURCE CODE

Available at: [v.lrs.segment source code](https://github.com/OSGeo/grass/tree/main/vector/v.lrs/v.lrs.segment)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.lrs/v.lrs.segment))  
Latest change: Wednesday Jul 02 11:14:35 2025 in commit [99682b0](https://github.com/OSGeo/grass/commit/99682b0ce35a99593a2f048c9200fd21f735b2ff)
