---
name: v.import.py
description: Imports vector data into a GRASS vector map using OGR library and reprojects on the fly.
keywords: [ vector, import, projection ]
---

# v.import.py

Imports vector data into a GRASS vector map using OGR library and reprojects on the fly.

=== "Command line"

    **v.import.py**
    [**-flo**]
    **input**=*string*
    [**layer**=*string* [,*string*,...]]
    [**output**=*name*]
    [**extent**=*string*]
    [**encoding**=*string*]
    [**snap**=*float*]
    [**epsg**=*integer*]
    [**datum_trans**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.import.py input=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.import.py***",
        **input**,
        **layer**=*None*,
        **output**=*None*,
        **extent**=*"input"*,
        **encoding**=*None*,
        **snap**=*-1*,
        **epsg**=*None*,
        **datum_trans**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.import.py", input="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_import_py*(**input**,
        **layer**=*None*,
        **output**=*None*,
        **extent**=*"input"*,
        **encoding**=*None*,
        **snap**=*-1*,
        **epsg**=*None*,
        **datum_trans**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_import_py(input="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR datasource to be imported  
    **layer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer name. If not given, all available layers are imported  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map (default: input)  
    **extent**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    **encoding**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    **snap**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;A suitable threshold is estimated during import  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **epsg**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG projection code  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000000*  
    **datum_trans**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Index number of datum transform parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;-1 to list available datum transform parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-1-100*  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported OGR formats and exit  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available OGR layers in data source and exit  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system (CRS) as the current project  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR datasource to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer name. If not given, all available layers are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource_layer  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map (default: input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    **snap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;A suitable threshold is estimated during import  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **epsg** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG projection code  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000000*  
    **datum_trans** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Index number of datum transform parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;-1 to list available datum transform parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-1-100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *l*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported OGR formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available OGR layers in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system (CRS) as the current project  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR datasource to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer name. If not given, all available layers are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource_layer  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map (default: input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **extent** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map extent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, region*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: extent of input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: extent of current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    **snap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Snapping threshold for boundaries (map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;A suitable threshold is estimated during import  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **epsg** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG projection code  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000000*  
    **datum_trans** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Index number of datum transform parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;-1 to list available datum transform parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-1-100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *l*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported OGR formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available OGR layers in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system (CRS) as the current project  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.import* imports vector data from files and database connections
supported by the [OGR](https://gdal.org/) library into the current
project (previously called location) and mapset. If the coordinate
reference system (CRS) of the input does not match the CRS of the
project, the input is reprojected into the current project. In case that
the CRS of the input map does match the CRS of the project, the input is
imported directly.

### Supported Vector Formats

*v.import* uses the OGR library which supports various vector data
formats including [ESRI
Shapefile](https://gdal.org/en/stable/drivers/vector/shapefile.html),
[Mapinfo File](https://gdal.org/en/stable/drivers/vector/mitab.html), UK
.NTF, SDTS, TIGER, IHO S-57 (ENC), DGN, GML, GPX, AVCBin, REC, Memory,
OGDI, and PostgreSQL, depending on the local OGR installation. For
details see the [OGR web
site](https://gdal.org/en/stable/drivers/vector/). The OGR (Simple
Features Library) is part of the [GDAL](https://gdal.org) library, hence
GDAL needs to be installed to use *v.import*.

The list of actually supported formats can be printed by **-f** flag.

## NOTES

*v.import* checks the CRS metadata of the dataset to be imported against
that of the current project. If not identical a related error message is
shown.  
To override this CRS check (i.e. to use current project's CRS) by
assuming that the dataset has the same CRS as the current project the
**-o** flag can be used. This is also useful when geodata to be imported
do not contain any CRS metadata at all. The user must be sure that the
CRS is identical in order to avoid introducing data errors.

### Topology cleaning

When importing polygons, non-topological polygons are converted to
topological areas. If the input polygons contain errors (unexpected
overlapping areas, small gaps between polygons, or warnings about being
unable to calculate centroids), the import might need to be repeated
using a *snap* value as suggested in the output messages. The default
value of `snap=-1` means that no snapping will be done.

The *snap* threshold defines the maximal distance from one to another
vertex in map units (for latitude-longitude projects in degrees). If
there is no other vertex within *snap* distance, no snapping will be
done. Note that a too large value can severely damage area topology,
beyond repair.

*Post-processing:* Snapped boundaries may need to be cleaned with
*v.clean*, using its tools *break,rmdupl,rmsa*. For details, refer to
the *v.clean* manual page.

## EXAMPLE

```sh
# import SHAPE file at full extent and reproject to current project CRS
v.import input=research_area.shp output=research_area extent=input
```

## SEE ALSO

*[v.clean](v.clean.md), [v.in.lines](v.in.lines.md),
[v.in.ogr](v.in.ogr.md), [v.proj](v.proj.md)*

## AUTHORS

Markus Metz  
Improvements: Martin Landa, Anna Petrasova

## SOURCE CODE

Available at: [v.import source code](https://github.com/OSGeo/grass/tree/main/scripts/v.import)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.import))  
Latest change: Sunday Nov 09 19:22:25 2025 in commit [7335bd5](https://github.com/OSGeo/grass/commit/7335bd572fec91187fef5f9a6c2e984caf4650fc)
