---
title: Raster tools
author: GRASS Development Team
---

# Raster tools

To learn more about these tool in general, go to [Raster introduction](rasterintro.md).

| Name | Description |
|--------|-------------|
| [r.basins.fill](r.basins.fill.md) | Generates watershed subbasins raster map. |
| [r.blend](r.blend.md) | Blends color components of two raster maps by a given ratio. |
| [r.buffer.lowmem](r.buffer.lowmem.md) | Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values. This is the low-memory alternative to the classic r.buffer module. |
| [r.buffer](r.buffer.md) | Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values. |
| [r.buildvrt](r.buildvrt.md) | Build a VRT (Virtual Raster) from the list of input raster maps. |
| [r.carve](r.carve.md) | Generates stream channels. Takes vector stream data, transforms it to raster and subtracts depth from the output DEM. |
| [r.category](r.category.md) | Manages category values and labels associated with user-specified raster map layers. |
| [r.circle](r.circle.md) | Creates a raster map containing concentric rings around a given point. |
| [r.clump](r.clump.md) | Recategorizes data in a raster map by grouping cells that form physically discrete areas into unique categories. |
| [r.coin](r.coin.md) | Tabulates the mutual occurrence (coincidence) of categories for two raster map layers. |
| [r.colors](r.colors.md) | Creates/modifies the color table associated with a raster map. |
| [r.colors.out](r.colors.out.md) | Exports the color table associated with a raster map. |
| [r.colors.stddev](r.colors.stddev.md) | Sets color rules based on stddev from a raster map's mean value. |
| [r.composite](r.composite.md) | Combines red, green and blue raster maps into a single composite raster map. |
| [r.compress](r.compress.md) | Compresses and decompresses raster maps. |
| [r.contour](r.contour.md) | Produces a vector map of specified contours from a raster map. |
| [r.cost](r.cost.md) | Creates a raster map showing the cumulative cost of moving between different geographic locations on an input raster map whose cell category values represent cost. |
| [r.covar](r.covar.md) | Outputs a covariance/correlation matrix for user-specified raster map layer(s). |
| [r.cross](r.cross.md) | Creates a cross product of the category values from multiple raster map layers. |
| [r.describe](r.describe.md) | Prints terse list of category values found in a raster map layer. |
| [r.distance](r.distance.md) | Locates the closest points between objects in two raster maps. |
| [r.drain](r.drain.md) | Traces a flow through an elevation model or cost surface on a raster map. |
| [r.external](r.external.md) | Links GDAL supported raster data as a pseudo GRASS raster map. |
| [r.external.out](r.external.out.md) | Redirects raster output to file utilizing GDAL library rather than storing in GRASS raster format. |
| [r.fill.dir](r.fill.dir.md) | Filters and generates a depressionless elevation map and a flow direction map from a given elevation raster map. |
| [r.fill.stats](r.fill.stats.md) | Rapidly fills 'no data' cells (NULLs) of a raster map with interpolated values (IDW). |
| [r.fillnulls](r.fillnulls.md) | Fills no-data areas in raster maps using spline interpolation. |
| [r.flow](r.flow.md) | Constructs flowlines. Computes flowlines, flowpath lengths, and flowaccumulation (contributing areas) from a elevation raster map. |
| [r.geomorphon](r.geomorphon.md) | Calculates geomorphons (terrain forms) and associated geometry using machine vision approach. |
| [r.grow.distance](r.grow.distance.md) | Generates a raster map containing distances to nearest raster features and/or the value of the nearest non-null cell. |
| [r.grow](r.grow.md) | Generates a raster map layer with contiguous areas grown by one cell. |
| [r.gwflow](r.gwflow.md) | Numerical calculation program for transient, confined and unconfined groundwater flow in two dimensions. |
| [r.his](r.his.md) | Generates red, green and blue (RGB) raster map layers combining hue, intensity and saturation (HIS) values from user-specified input raster map layers. |
| [r.horizon](r.horizon.md) | Computes horizon angle height from a digital elevation model. The module has two different modes of operation: 1. Computes the entire horizon around a single point whose coordinates are given with the 'coord' option. The horizon height (in radians). 2. Computes one or more raster maps of the horizon height in a single direction. The input for this is the angle (in degrees), which is measured counterclockwise with east=0, north=90 etc. The output is the horizon height in radians. |
| [r.import](r.import.md) | Imports raster data into a GRASS raster map using GDAL library and reprojects on the fly. |
| [r.in.ascii](r.in.ascii.md) | Converts a GRASS ASCII raster file to binary raster map. |
| [r.in.aster](r.in.aster.md) | Georeference, rectify, and import Terra-ASTER imagery and relative DEMs using gdalwarp. |
| [r.in.bin](r.in.bin.md) | Import a binary raster file into a GRASS raster map layer. |
| [r.in.gdal](r.in.gdal.md) | Imports raster data into a GRASS raster map using GDAL library. |
| [r.in.gridatb](r.in.gridatb.md) | Imports GRIDATB.FOR map file (TOPMODEL) into a GRASS raster map. |
| [r.in.lidar](r.in.lidar.md) | Creates a raster map from LAS LiDAR points using univariate statistics. |
| [r.in.mat](r.in.mat.md) | Imports a binary MAT-File(v4) to a GRASS raster. |
| [r.in.png](r.in.png.md) | Imports non-georeferenced PNG format image. |
| [r.in.poly](r.in.poly.md) | Creates raster maps from ASCII polygon/line/point data files. |
| [r.in.srtm](r.in.srtm.md) | Imports SRTM HGT files into raster map. |
| [r.in.wms](r.in.wms.md) | Downloads and imports data from OGC WMS and OGC WMTS web mapping servers. |
| [r.in.xyz](r.in.xyz.md) | Creates a raster map from an assemblage of many coordinates using univariate statistics. |
| [r.info](r.info.md) | Outputs basic information about a raster map. |
| [r.kappa](r.kappa.md) | Calculates error matrix and kappa parameter for accuracy assessment of classification result. |
| [r.lake](r.lake.md) | Fills lake at given point to given level. |
| [r.latlong](r.latlong.md) | Creates a latitude/longitude raster map. |
| [r.li.cwed](r.li.cwed.md) | Calculates contrast weighted edge density index on a raster map |
| [r.li.daemon](r.li.daemon.md) | Support module for r.li landscape index calculations. |
| [r.li.dominance](r.li.dominance.md) | Calculates dominance's diversity index on a raster map |
| [r.li.edgedensity](r.li.edgedensity.md) | Calculates edge density index on a raster map, using a 4 neighbour algorithm |
| [r.li](r.li.md) | Landscape structure analysis package overview |
| [r.li.mpa](r.li.mpa.md) | Calculates mean pixel attribute index on a raster map |
| [r.li.mps](r.li.mps.md) | Calculates mean patch size index on a raster map, using a 4 neighbour algorithm |
| [r.li.padcv](r.li.padcv.md) | Calculates coefficient of variation of patch area on a raster map |
| [r.li.padrange](r.li.padrange.md) | Calculates range of patch area size on a raster map |
| [r.li.padsd](r.li.padsd.md) | Calculates standard deviation of patch area a raster map |
| [r.li.patchdensity](r.li.patchdensity.md) | Calculates patch density index on a raster map, using a 4 neighbour algorithm |
| [r.li.patchnum](r.li.patchnum.md) | Calculates patch number index on a raster map, using a 4 neighbour algorithm. |
| [r.li.pielou](r.li.pielou.md) | Calculates Pielou's diversity index on a raster map |
| [r.li.renyi](r.li.renyi.md) | Calculates Renyi's diversity index on a raster map |
| [r.li.richness](r.li.richness.md) | Calculates richness index on a raster map |
| [r.li.shannon](r.li.shannon.md) | Calculates Shannon's diversity index on a raster map |
| [r.li.shape](r.li.shape.md) | Calculates shape index on a raster map |
| [r.li.simpson](r.li.simpson.md) | Calculates Simpson's diversity index on a raster map |
| [r.mapcalc](r.mapcalc.md) | Raster map calculator. |
| [r.mapcalc.simple](r.mapcalc.simple.md) | Calculates a new raster map from a simple r.mapcalc expression. |
| [r.mask](r.mask.md) | Creates a raster mask for limiting raster operation. |
| [r.mask.status](r.mask.status.md) | Reports presence or absence of a raster mask Provides information about the presence of a 2D raster mask as text output or return code |
| [r.mfilter](r.mfilter.md) | Performs raster map matrix filter. |
| [r.mode](r.mode.md) | Finds the mode of values in a cover map within areas assigned the same category value in a user-specified base map. |
| [r.neighbors](r.neighbors.md) | Makes each cell category value a function of the category values assigned to the cells around it, and stores new cell values in an output raster map layer. |
| [r.null](r.null.md) | Manages NULL-values of given raster map. |
| [r.object.geometry](r.object.geometry.md) | Calculates geometry parameters for raster objects. |
| [r.out.ascii](r.out.ascii.md) | Converts a raster map layer into a GRASS ASCII text file. |
| [r.out.bin](r.out.bin.md) | Exports a GRASS raster to a binary array. |
| [r.out.gdal](r.out.gdal.md) | Exports GRASS raster maps into GDAL supported formats. |
| [r.out.gridatb](r.out.gridatb.md) | Exports GRASS raster map to GRIDATB.FOR map file (TOPMODEL). |
| [r.out.mat](r.out.mat.md) | Exports a GRASS raster to a binary MAT-File. |
| [r.out.mpeg](r.out.mpeg.md) | Converts raster map series to MPEG movie. |
| [r.out.png](r.out.png.md) | Export a GRASS raster map as a non-georeferenced PNG image. |
| [r.out.pov](r.out.pov.md) | Converts a raster map layer into a height-field file for POV-Ray. |
| [r.out.ppm](r.out.ppm.md) | Converts a GRASS raster map to a PPM image file. |
| [r.out.ppm3](r.out.ppm3.md) | Converts 3 GRASS raster layers (R,G,B) to a PPM image file. |
| [r.out.vrml](r.out.vrml.md) | Exports a raster map to the Virtual Reality Modeling Language (VRML). |
| [r.out.vtk](r.out.vtk.md) | Converts raster maps into the VTK-ASCII format. |
| [r.out.xyz](r.out.xyz.md) | Exports a raster map to a text file as x,y,z values based on cell centers. |
| [r.pack](r.pack.md) | Exports a raster map as GRASS specific archive file |
| [r.param.scale](r.param.scale.md) | Extracts terrain parameters from a DEM. Uses a multi-scale approach by taking fitting quadratic parameters to any size window (via least squares). |
| [r.patch](r.patch.md) | Creates a composite raster map layer by using known category values from one (or more) map layer(s) to fill in areas of "no data" in another map layer. |
| [r.path](r.path.md) | Traces paths from starting points following input directions. |
| [r.plane](r.plane.md) | Creates raster plane map given dip (inclination), aspect (azimuth) and one point. |
| [r.profile](r.profile.md) | Outputs the raster map layer values lying on user-defined line(s). |
| [r.proj](r.proj.md) | Re-projects a raster map from given project to the current project. |
| [r.quant](r.quant.md) | Produces the quantization file for a floating-point map. |
| [r.quantile](r.quantile.md) | Compute quantiles using two passes. |
| [r.random.cells](r.random.cells.md) | Generates random cell values with spatial dependence. |
| [r.random](r.random.md) | Creates randomly placed raster cells or vector points Creates a raster map and vector point map containing randomly located cells and points. |
| [r.random.surface](r.random.surface.md) | Generates random surface(s) with spatial dependence. |
| [r.reclass.area](r.reclass.area.md) | Reclasses a raster map greater or less than user specified area size (in hectares). |
| [r.reclass](r.reclass.md) | Reclassify raster map based on category values. Creates a new raster map whose category values are based upon a reclassification of the categories in an existing raster map. |
| [r.recode](r.recode.md) | Recodes categorical raster maps. |
| [r.region](r.region.md) | Sets the boundary definitions for a raster map. |
| [r.regression.line](r.regression.line.md) | Calculates linear regression from two raster maps: y = a + b*x. |
| [r.regression.multi](r.regression.multi.md) | Calculates multiple linear regression from raster maps. |
| [r.relief](r.relief.md) | Creates shaded relief map from an elevation map (DEM). |
| [r.report](r.report.md) | Reports statistics for raster maps. |
| [r.resamp.bspline](r.resamp.bspline.md) | Performs bilinear or bicubic spline interpolation with Tykhonov regularization. |
| [r.resamp.filter](r.resamp.filter.md) | Resamples raster map layers using an analytic kernel. |
| [r.resamp.interp](r.resamp.interp.md) | Resamples raster map to a finer grid using interpolation. |
| [r.resamp.rst](r.resamp.rst.md) | Reinterpolates and optionally computes topographic analysis from input raster map to a new raster map (possibly with different resolution) using regularized spline with tension and smoothing. |
| [r.resamp.stats](r.resamp.stats.md) | Resamples raster map layers to a coarser grid using aggregation. |
| [r.resample](r.resample.md) | GRASS raster map layer data resampling capability. |
| [r.rescale.eq](r.rescale.eq.md) | Rescales histogram equalized the range of category values in a raster map layer. |
| [r.rescale](r.rescale.md) | Rescales the range of category values in a raster map layer. |
| [r.rgb](r.rgb.md) | Splits a raster map into red, green and blue maps. |
| [r.ros](r.ros.md) | Generates rate of spread raster maps. Generates three, or four raster map layers showing the base (perpendicular) rate of spread (ROS), the maximum (forward) ROS, the direction of the maximum ROS, and optionally the maximum potential spotting distance for fire spread simulation. |
| [r.semantic.label](r.semantic.label.md) | Manages semantic label information assigned to a single raster map or to a list of raster maps. |
| [r.series.accumulate](r.series.accumulate.md) | Makes each output cell value a accumulationfunction of the values assigned to the corresponding cells in the input raster map layers. |
| [r.series.interp](r.series.interp.md) | Interpolates raster maps located (temporal or spatial) in between input raster maps at specific sampling positions. |
| [r.series](r.series.md) | Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers. |
| [r.shade](r.shade.md) | Drapes a color raster over an shaded relief or aspect map. |
| [r.sim.sediment](r.sim.sediment.md) | Sediment transport and erosion/deposition simulation using path sampling method (SIMWE). |
| [r.sim.water](r.sim.water.md) | Overland flow hydrologic simulation using path sampling method (SIMWE). |
| [r.slope.aspect](r.slope.aspect.md) | Generates raster maps of slope, aspect, curvatures and partial derivatives from an elevation raster map. Aspect is calculated counterclockwise from east. |
| [r.smooth.edgepreserve](r.smooth.edgepreserve.md) | Smoothing with anisotropic diffusion |
| [r.solute.transport](r.solute.transport.md) | Numerical calculation program for transient, confined and unconfined solute transport in two dimensions |
| [r.spread](r.spread.md) | Simulates elliptically anisotropic spread. Generates a raster map of the cumulative time of spread, given raster maps containing the rates of spread (ROS), the ROS directions and the spread origins. It optionally produces raster maps to contain backlink UTM coordinates for tracing spread paths. Usable for fire spread simulations. |
| [r.spreadpath](r.spreadpath.md) | Recursively traces the least cost path backwards to cells from which the cumulative cost was determined. |
| [r.statistics](r.statistics.md) | Calculates category or object oriented statistics. |
| [r.stats](r.stats.md) | Generates area statistics for raster map. |
| [r.stats.quantile](r.stats.quantile.md) | Compute category quantiles using two passes. |
| [r.stats.zonal](r.stats.zonal.md) | Calculates category or object oriented statistics (accumulator-based statistics). |
| [r.stream.extract](r.stream.extract.md) | Performs stream network extraction. |
| [r.sun](r.sun.md) | Solar irradiance and irradiation model. Computes direct (beam), diffuse and reflected solar irradiation raster maps for given day, latitude, surface and atmospheric conditions. Solar parameters (e.g. sunrise, sunset times, declination, extraterrestrial irradiance, daylight length) are saved in the map history file. Alternatively, a local time can be specified to compute solar incidence angle and/or irradiance raster maps. The shadowing effect of the topography is optionally incorporated. |
| [r.sunhours](r.sunhours.md) | Calculates solar elevation, solar azimuth, and sun hours. Solar elevation: the angle between the direction of the geometric center of the sun's apparent disk and the (idealized) horizon. Solar azimuth: the angle from due north in clockwise direction. |
| [r.sunmask](r.sunmask.md) | Calculates cast shadow areas from sun position and elevation raster map. Either exact sun position (A) is specified, or date/time to calculate the sun position (B) by r.sunmask itself. |
| [r.support](r.support.md) | Allows creation and/or modification of raster map layer support files. |
| [r.support.stats](r.support.stats.md) | Update raster map statistics |
| [r.surf.area](r.surf.area.md) | Prints estimation of surface area for raster map. |
| [r.surf.contour](r.surf.contour.md) | Generates surface raster map from rasterized contours. |
| [r.surf.fractal](r.surf.fractal.md) | Creates a fractal surface of a given fractal dimension. |
| [r.surf.gauss](r.surf.gauss.md) | Generates a raster map using gaussian random number generator. Mean and standard deviation of gaussian deviates can be expressed by the user. |
| [r.surf.idw](r.surf.idw.md) | Provides surface interpolation from raster point data by Inverse Distance Squared Weighting. |
| [r.surf.random](r.surf.random.md) | Produces a raster surface map of uniform random deviates with defined range. |
| [r.terraflow](r.terraflow.md) | Performs flow computation for massive grids. |
| [r.texture](r.texture.md) | Generate images with textural features from a raster map. |
| [r.thin](r.thin.md) | Thins non-null cells that denote linear features in a raster map layer. |
| [r.tile](r.tile.md) | Splits a raster map into tiles. |
| [r.tileset](r.tileset.md) | Produces tilings of the source projection for use in the destination region and projection. |
| [r.timestamp](r.timestamp.md) | Modifies a timestamp for a raster map. Print/add/remove a timestamp for a raster map. |
| [r.to.rast3](r.to.rast3.md) | Converts 2D raster map slices to one 3D raster volume map. |
| [r.to.rast3elev](r.to.rast3elev.md) | Creates a 3D volume map based on 2D elevation and value raster maps. |
| [r.to.vect](r.to.vect.md) | Converts a raster map into a vector map. |
| [r.topidx](r.topidx.md) | Creates a topographic index (wetness index) raster map from an elevation raster map. |
| [r.topmodel](r.topmodel.md) | Simulates TOPMODEL which is a physically based hydrologic model. |
| [r.transect](r.transect.md) | Outputs raster map layer values lying along user defined transect line(s). |
| [r.univar](r.univar.md) | Calculates univariate statistics from the non-null cells of a raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum. |
| [r.unpack](r.unpack.md) | Imports a GRASS specific raster archive file (packed with r.pack) as a raster map |
| [r.uslek](r.uslek.md) | Computes USLE Soil Erodibility Factor (K). |
| [r.usler](r.usler.md) | Computes USLE R factor, Rainfall erosivity index. |
| [r.viewshed](r.viewshed.md) | Computes the viewshed of a point on an elevation raster map. Default format: NULL (invisible), vertical angle wrt viewpoint (visible). |
| [r.volume](r.volume.md) | Calculates the volume of data "clumps". Optionally produces a GRASS vector points map containing the calculated centroids of these clumps. |
| [r.walk](r.walk.md) | Creates a raster map showing the anisotropic cumulative cost of moving between different geographic locations on an input raster map whose cell category values represent cost. |
| [r.water.outlet](r.water.outlet.md) | Creates watershed basins from a drainage direction map. |
| [r.watershed](r.watershed.md) | Calculates hydrological parameters and RUSLE factors. |
| [r.what.color](r.what.color.md) | Queries colors for a raster map layer. |
| [r.what](r.what.md) | Queries raster maps on their category values and category labels. |
