---
name: r.reclass.area.py
description: Reclasses a raster map greater or less than user specified area size (in hectares).
keywords: [ raster, statistics, aggregation ]
---

# r.reclass.area.py

Reclasses a raster map greater or less than user specified area size (in hectares).

=== "Command line"

    **r.reclass.area.py**
    [**-cd**]
    **input**=*name*
    **output**=*name*
    **value**=*float*
    **mode**=*string*
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.reclass.area.py input=name output=name value=0.0 mode=lesser
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.reclass.area.py***",
        **input**,
        **output**,
        **value**,
        **mode**,
        **method**=*"reclass"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.reclass.area.py", input="name", output="name", value=0.0, mode="lesser")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_reclass_area_py*(**input**,
        **output**,
        **value**,
        **mode**,
        **method**=*"reclass"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_reclass_area_py(input="name", output="name", value=0.0, mode="lesser")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **value**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value option that sets the area size limit (in hectares)  
    **mode**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Lesser or greater than specified value  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lesser, greater*  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *reclass, rmarea*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *reclass*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map is clumped  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Clumps including diagonal neighbors  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **value** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value option that sets the area size limit (in hectares)  
    **mode** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lesser or greater than specified value  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lesser, greater*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *reclass, rmarea*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *reclass*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input map is clumped  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clumps including diagonal neighbors  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **value** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value option that sets the area size limit (in hectares)  
    **mode** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lesser or greater than specified value  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lesser, greater*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for reclassification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *reclass, rmarea*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *reclass*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input map is clumped  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clumps including diagonal neighbors  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.reclass.area* reclasses a raster map greater or less than a user
specified area size (in hectares).

If the **-c** flag is used, *r.reclass.area* will skip the creation of a
clumped raster and assume that the input raster is already clumped.

## EXAMPLES

In this example, the ZIP code map in the North Carolina sample dataset
is filtered for large areas (removing smaller areas from the map).

```sh
g.region raster=zipcodes -p
r.report zipcodes unit=h
```

Extract only areas greater than 2000 ha, NULL otherwise:

```sh
r.reclass.area input=zipcodes output=zipcodes_larger2000ha mode=greater value=2000

r.report zipcodes_larger2000ha unit=h
```

![Figure: r.reclass.area method=reclass](zipcodes_larger2000ha.png)  
*Figure: r.reclass.area method=reclass*

In this example, the ZIP code map in the North Carolina sample dataset
is filtered for smaller areas which are substituted with the value of
the respective adjacent area with largest shared boundary. Reclass by
substitutional removing of areas minor of 1000 ha:

```sh
r.reclass.area input=zipcodes output=zipcodes_minor1000ha mode=lesser value=1000 method=rmarea
```

![Figure: r.reclass.area method=rmarea](zipcodes_minor1000ha.png)  
*Figure: r.reclass.area method=rmarea*

## SEE ALSO

*[r.reclass](r.reclass.md), [r.clump](r.clump.md),
[r.stats](r.stats.md)*

## AUTHORS

NRCS,  
Markus Neteler

## SOURCE CODE

Available at: [r.reclass.area source code](https://github.com/OSGeo/grass/tree/main/scripts/r.reclass.area)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.reclass.area))  
Latest change: Thursday May 22 05:23:53 2025 in commit [199e858](https://github.com/OSGeo/grass/commit/199e858c3770ff4c3b2b6ad073c1374169adbece)
