---
name: r.in.aster.py
description: Georeference, rectify, and import Terra-ASTER imagery and relative DEMs using gdalwarp.
keywords: [ raster, import, imagery, ASTER, elevation ]
---

# r.in.aster.py

Georeference, rectify, and import Terra-ASTER imagery and relative DEMs using gdalwarp.

=== "Command line"

    **r.in.aster.py**
    **input**=*name*
    **proctype**=*string*
    **band**=*string*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.in.aster.py input=name proctype=L1B band=all output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.in.aster.py***",
        **input**,
        **proctype**=*"L1B"*,
        **band**=*"all"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.in.aster.py", input="name", proctype="L1B", band="all", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_in_aster_py*(**input**,
        **proctype**=*"L1B"*,
        **band**=*"all"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_in_aster_py(input="name", proctype="L1B", band="all", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input ASTER image  
    **proctype**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;ASTER imagery processing type (Level 1A, Level 1B, or relative DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *L1A, L1B, L1T, DEM*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *L1B*  
    **band**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;List L1A L1B or L1T band to translate (1,2,3n,...), or enter 'all' to translate all bands  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *all*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output raster map (band number will be appended to base name)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input ASTER image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **proctype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;ASTER imagery processing type (Level 1A, Level 1B, or relative DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *L1A, L1B, L1T, DEM*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *L1B*  
    **band** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;List L1A L1B or L1T band to translate (1,2,3n,...), or enter 'all' to translate all bands  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *all*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output raster map (band number will be appended to base name)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input ASTER image  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **proctype** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;ASTER imagery processing type (Level 1A, Level 1B, or relative DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *L1A, L1B, L1T, DEM*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *L1B*  
    **band** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;List L1A L1B or L1T band to translate (1,2,3n,...), or enter 'all' to translate all bands  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *all*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output raster map (band number will be appended to base name)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.in.aster* rectifies, georeferences, and imports Terra-ASTER imagery
to current project using gdalwarp, hdf 4, and r.in.gdal, using
projection parameters from g.proj. It can import Level 1A, Level 1B,
their relative DEM products, and Level 1T.

The program may be run interactively or non-interactively from the
command line. In either case, the user must specify an **input** \*.hdf
file name, the **type** of processing used, the image **band** to
import, and an **output** GRASS raster map name.

The **type** parameter can take values of L1A, L1B, L1T or DEM.

The **band** parameter can take values of 1, 2, 3n, 3b, 4-14

## NOTES

*r.in.aster* requires GDAL library to be in the user's path and the hdf
4 driver to be installed. The GDAL library must be compiled with hdf
support.

## AUTHORS

Michael Barton, Arizona State University and Paul Kelly

## SOURCE CODE

Available at: [r.in.aster source code](https://github.com/OSGeo/grass/tree/main/scripts/r.in.aster)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.in.aster))  
Latest change: Thursday May 22 03:42:15 2025 in commit [370bcb0](https://github.com/OSGeo/grass/commit/370bcb0490b421ac90b2dbe5766af9512cb08f92)
