---
name: d.grid
description: Overlays a user-specified grid in the active display frame on the graphics monitor.
keywords: [ display, cartography, graticule, grid ]
---

# d.grid

Overlays a user-specified grid in the active display frame on the graphics monitor.

=== "Command line"

    **d.grid**
    [**-agwcdfnbt**]
    **size**=*value*
    [**origin**=*east,north*]
    [**direction**=*string*]
    [**width**=*float*]
    [**color**=*name*]
    [**border_color**=*name*]
    [**text_color**=*name*]
    [**bgcolor**=*name*]
    [**fontsize**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.grid size=value
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***d.grid***",
        **size**,
        **origin**=*"0,0"*,
        **direction**=*"both"*,
        **width**=*None*,
        **color**=*"gray"*,
        **border_color**=*"black"*,
        **text_color**=*"gray"*,
        **bgcolor**=*"none"*,
        **fontsize**=*9*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("d.grid", size="value")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_grid*(**size**,
        **origin**=*"0,0"*,
        **direction**=*"both"*,
        **width**=*None*,
        **color**=*"gray"*,
        **border_color**=*"black"*,
        **text_color**=*"gray"*,
        **bgcolor**=*"none"*,
        **fontsize**=*9*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_grid(size="value")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **size**=*value* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of grid to be drawn (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;0 for north-south resolution of the current region. In map units or DDD:MM:SS format. Example: "1000" or "0:10"  
    **origin**=*east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lines of the grid pass through this coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **direction**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw only east-west lines, north-south lines, or both   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *both, east-west, north-south*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *both*  
    **width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid line width  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **border_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **fontsize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size for gridline coordinate labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-72*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Align the origin to the east-north corner of the current region  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw geographic grid (referenced to current ellipsoid)  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw geographic grid (referenced to WGS84 ellipsoid)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw '+' marks instead of grid lines  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw '.' marks instead of grid lines  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw fiducial marks instead of grid lines  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable grid drawing  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable border drawing  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Disable text drawing  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **size** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of grid to be drawn (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;0 for north-south resolution of the current region. In map units or DDD:MM:SS format. Example: "1000" or "0:10"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **origin** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lines of the grid pass through this coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **direction** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw only east-west lines, north-south lines, or both   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *both, east-west, north-south*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *both*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid line width  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **border_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size for gridline coordinate labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-72*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *g*, *w*, *c*, *d*, *f*, *n*, *b*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align the origin to the east-north corner of the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw geographic grid (referenced to current ellipsoid)  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw geographic grid (referenced to WGS84 ellipsoid)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw '+' marks instead of grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw '.' marks instead of grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw fiducial marks instead of grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable grid drawing  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable border drawing  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable text drawing  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **size** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of grid to be drawn (in map units)  
    &nbsp;&nbsp;&nbsp;&nbsp;0 for north-south resolution of the current region. In map units or DDD:MM:SS format. Example: "1000" or "0:10"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    **origin** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lines of the grid pass through this coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **direction** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw only east-west lines, north-south lines, or both   
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *both, east-west, north-south*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *both*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid line width  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Grid color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **border_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **text_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size for gridline coordinate labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-72*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *9*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *g*, *w*, *c*, *d*, *f*, *n*, *b*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Align the origin to the east-north corner of the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw geographic grid (referenced to current ellipsoid)  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw geographic grid (referenced to WGS84 ellipsoid)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw '+' marks instead of grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw '.' marks instead of grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw fiducial marks instead of grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable grid drawing  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable border drawing  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Disable text drawing  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.grid* overlays a grid of user-defined size and color in the active
display frame on the graphics monitor. The grid can be created as a
standard rectangular grid or a geographic grid.

If the user provides a **-g** flag a geographic (projected) grid will be
drawn. With the **-g** flag the **size** argument accepts both decimal
degrees and colon separated ddd:mm:ss coordinates (eg. `00:30:00` for
half of a degree). A geographic grid cannot be drawn for a
*latitude/longitude* or *XY* projection.

Colors may be standard named GRASS colors (red, green, aqua, etc.) or a
numerical R:G:B triplet, where component values range from 0-255. Grid
color can be set with option **color**. Options **text_color** and
**bgcolor** set the color of the text and its background.

The grid drawing may be turned off by using the **-n** flag.  
The border drawing may be turned off by using the **-b** flag.  
The coordinate text may be turned off by using the **-t** flag.  

To draw grid lines at different intervals, e.g. at high latitudes, you
can run the module twice, once with **direction**=*east-west* at one
interval **size**, and again with **direction**=*north-south* at another
interval **size**.

## EXAMPLES

To draw a red geographic grid with 30 minute grid spacing, run one of
the following commands:

```sh
d.grid -g size=00:30:00 color=red
```

or

```sh
d.grid -g size=0.5 color=255:0:0
```

![d.grid red grid example](d_grid_red_grid.png)  
*Figure: Showing a geographic grid in red line color*

To draw a blue standard rectangular grid at a 500 (meter) spacing run
the following:

```sh
d.grid size=500 color=blue
```

![d.grid blue grid example](d_grid_blue_grid.png)  
*Figure: Showing a rectangular grid in blue line color*

## SEE ALSO

*[d.barscale](d.barscale.md), [d.legend](d.legend.md),
[d.geodesic](d.geodesic.md), [d.rhumbline](d.rhumbline.md),
[d.erase](d.erase.md), [d.frame](d.frame.md), [d.rast](d.rast.md),
[v.mkgrid](v.mkgrid.md)*

## AUTHORS

James Westervelt, U.S. Army Construction Engineering Research
Laboratory  
Geogrid support: Bob Covill  
Border support: Markus Neteler  
Text and RGB support: Hamish Bowman  
Background color implemented as part of GSoC 2016 by Adam Laza, CTU in
Prague

## SOURCE CODE

Available at: [d.grid source code](https://github.com/OSGeo/grass/tree/main/display/d.grid)
([history](https://github.com/OSGeo/grass/commits/main/display/d.grid))  
Latest change: Monday Dec 08 21:47:55 2025 in commit [d3c6479](https://github.com/OSGeo/grass/commit/d3c6479bef77a58e3b5d85259303dbfb9c1babe8)
