---
description: wxGUI in GRASS GIS
index: wxgui
---

# wxGUI in GRASS GIS

## Introduction to the GRASS GIS Graphical User Interface

### Overview

The wxGUI (wxPython-based Graphical User Interface) is the primary user
interface for GRASS GIS. Designed for efficiency and ease of use, the
wxGUI provides an intuitive way to interact with spatial data and the
powerful tools available in GRASS GIS. The GUI supports the
visualisation of spatial data, the execution of geoprocessing tasks or
the management of complex workflows and offers a comprehensive set of
tools.

### Features

The wxGUI is designed to cater to both novice and advanced users with
the following features:

- A clean and customizable layout for efficient workspace management.
- Integrated support for both raster and vector data operations.
- Drag-and-drop capabilities for quick layer addition and arrangement.
- Support for live previews of data and processing results.
- Direct access to GRASS GIS modules, complete with user-friendly dialog
  windows.
- Advanced debugging and scripting capabilities for developers and power
  users.

### Getting Started

To launch the wxGUI, simply start GRASS GIS. Upon startup, the wxGUI
will load, providing access to its various components. The wxGUI usage
is explained in greater detail [here](wxGUI.md). New GRASS GIS users can
explore the integrated help system or visit the [GRASS GIS
documentation](https://grass.osgeo.org/documentation/) for tutorials and
guides.

### Key Components

The wxGUI is composed of several modules and features:

- **Map Display**: Visualize raster, vector, and 3D data layers in an
  interactive map viewer.
- **Layer Manager**: Organize and control the visibility, styling, and
  properties of your data layers.
- **Data Catalog**: Explore and manage GRASS GIS mapsets and spatial
  data with ease.
- **Geoprocessing Tools**: Access a wide range of geospatial analysis
  and modeling tools through an easy-to-use interface.
- **Command Console**: Run GRASS GIS commands directly, with syntax
  highlighting and autocompletion support.
- **3D View**: Analyze and visualize 3D landscapes using NVIZ.

The wxGUI components are explained in greater detail
[here](wxGUI.components.md).

## See also

- [Introduction to raster data processing](rasterintro.md)
- [Introduction to 3D raster data (voxel) processing](raster3dintro.md)
- [Introduction to image processing](imageryintro.md)
- [Introduction into temporal data processing](temporalintro.md)
- [Introduction to database management](databaseintro.md)
- [Projections and spatial transformations](projectionintro.md)

## SOURCE CODE

Available at: [wxguiintro source code](https://github.com/OSGeo/grass/tree/main/gui)
([history](https://github.com/OSGeo/grass/commits/main/gui))  
Latest change: Sunday Apr 06 08:30:34 2025 in commit [defab0b](https://github.com/OSGeo/grass/commit/defab0b53c739b76d9e3ed6d3e8fd7661f4e0350)
