---
name: v.surf.idw
description: Provides surface interpolation from vector point data by Inverse Distance Squared Weighting.
keywords: [ vector, surface, interpolation, IDW ]
---

# v.surf.idw

Provides surface interpolation from vector point data by Inverse Distance Squared Weighting.

=== "Command line"

    **v.surf.idw**
    [**-n**]
    **input**=*name*
    [**layer**=*string*]
    [**column**=*name*]
    **output**=*name*
    [**npoints**=*count*]
    [**power**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.surf.idw input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.surf.idw***",
        **input**,
        **layer**=*"1"*,
        **column**=*None*,
        **output**,
        **npoints**=*12*,
        **power**=*2.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.surf.idw", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_surf_idw*(**input**,
        **layer**=*"1"*,
        **column**=*None*,
        **output**,
        **npoints**=*12*,
        **power**=*2.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_surf_idw(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with values to interpolate  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given and input is 2D vector map then category values are used. If input is 3D vector map then z-coordinates are used.  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **npoints**=*count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **power**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Power parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Greater values assign greater influence to closer points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.0*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Don't index points by raster cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Slower but uses less memory and includes points from outside region in the interpolation  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with values to interpolate  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given and input is 2D vector map then category values are used. If input is 3D vector map then z-coordinates are used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **npoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Power parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Greater values assign greater influence to closer points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't index points by raster cell  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Slower but uses less memory and includes points from outside region in the interpolation  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with values to interpolate  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given and input is 2D vector map then category values are used. If input is 3D vector map then z-coordinates are used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **npoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Power parameter  
    &nbsp;&nbsp;&nbsp;&nbsp;Greater values assign greater influence to closer points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't index points by raster cell  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Slower but uses less memory and includes points from outside region in the interpolation  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.surf.idw* fills a raster matrix with interpolated values generated
from a set of irregularly spaced vector data points using numerical
approximation (weighted averaging) techniques. The interpolated value of
a cell is determined by values of nearby data points and the distance of
the cell from those input points. In comparison with other methods,
numerical approximation allows representation of more complex surfaces
(particularly those with anomalous features), restricts the spatial
influence of any errors, and generates the interpolated surface from the
data points.

Values to interpolate are read from **column** option. If this option is
not given than the program uses *categories* as values to interpolate or
*z-coordinates* if the input vector map is 3D.

## NOTES

The amount of memory used by this program is related to the number of
vector points in the current region. If the vector point map is very
dense (i.e., contains many data points), the program may not be able to
get all the memory it needs from the system. The time required to
execute is related to the resolution of the current region, after an
initial delay determined by the time taken to read the input vector
points map.

Note that vector features without category in given **layer** are
*skipped*.

If the user has a mask set, then interpolation is only done for those
cells that fall within the mask. The module has two separate modes of
operation for selecting the vector points that are used in the
interpolation:

Simple, non-indexed mode (activated by **-n** flag)  
When the **-n** flag is specified, all vector points in the input vector
map are searched through in order to find the **npoints** closest points
to the centre of each cell in the output raster map. This mode of
operation can be slow in the case of a very large number of vector
points.

Default, indexed mode  
By default (i.e. if **-n** flag is *not* specified), prior to the
interpolation, input vector points are indexed according to which output
raster cell they fall into. This means that only cells nearby the one
being interpolated need to be searched to find the **npoints** closest
input points, and the module can run many times faster on dense input
maps. It should be noted that:

- Only vector points that lie within the current region are used in the
  interpolation. If there are points outside the current region, this
  may have an effect on the interpolated value of cells near the edges
  of the region, and this effect will be more pronounced the fewer
  points there are. If you wish to also include points outside the
  region in the interpolation, then either use the **-n** flag, or set
  the region to a larger extent (covering all input points) and use a
  mask to limit interpolation to a smaller area.
- If more than **npoints** points fall within a given cell then, rather
  than interpolating, these points are aggregated by taking the mean.
  This avoids the situation where some vector points can be discarded
  and not used in the interpolation, for very dense input maps. Again,
  use the **-n** flag if you wish to use only the **npoints** closest
  points to the cell centre under all circumstances.

The **power** parameter defines an exponential distance weight. Greater
values assign greater influence to values closer to the point to be
interpolated. The interpolation function peaks sharply over the given
data points for 0 \< *p* \< 1 and more smoothly for larger values. The
default value for the power parameter is 2.

By setting **npoints**=1, the module can be used to calculate raster
Voronoi diagrams (Thiessen polygons).

## SEE ALSO

*[g.region](g.region.md), [r.surf.contour](r.surf.contour.md),
[r.surf.idw](r.surf.idw.md), [r.surf.gauss](r.surf.gauss.md),
[r.surf.fractal](r.surf.fractal.md), [r.surf.random](r.surf.random.md),
[v.surf.rst](v.surf.rst.md)*

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research
Laboratory  
Improved algorithm (indexes points according to cell and ignores points
outside current region) by Paul Kelly

## SOURCE CODE

Available at: [v.surf.idw source code](https://github.com/OSGeo/grass/tree/main/vector/v.surf.idw)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.surf.idw))  
Latest change: Wednesday Sep 24 08:50:39 2025 in commit [23b5a22](https://github.com/OSGeo/grass/commit/23b5a22774d82a9af1e53b0f49fb9ab265675768)
