---
name: v.qcount
description: Indices for quadrat counts of vector point lists.
keywords: [ vector, statistics, point pattern ]
---

# v.qcount

Indices for quadrat counts of vector point lists.

=== "Command line"

    **v.qcount**
    [**-g**]
    **input**=*name*
    [**layer**=*string*]
    [**output**=*name*]
    **nquadrats**=*integer*
    **radius**=*float*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.qcount input=name nquadrats=0 radius=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.qcount***",
        **input**,
        **layer**=*"-1"*,
        **output**=*None*,
        **nquadrats**,
        **radius**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.qcount", input="name", nquadrats=0, radius=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_qcount*(**input**,
        **layer**=*"-1"*,
        **output**=*None*,
        **nquadrats**,
        **radius**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_qcount(input="name", nquadrats=0, radius=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output quadrat centers map (number of points is written as category)  
    **nquadrats**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quadrats  
    **radius**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quadrat radius  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print results in shell script style  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output quadrat centers map (number of points is written as category)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nquadrats** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quadrats  
    **radius** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quadrat radius  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print results in shell script style  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output quadrat centers map (number of points is written as category)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nquadrats** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quadrats  
    **radius** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quadrat radius  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print results in shell script style  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.qcount* computes six different quadrat count statistics that provide
a measure of how much an user defined point pattern departs from a
complete spatial random point pattern.

Points are distributed following a complete spatial randomness (CSR)
pattern if events are equally likely to occur anywhere within an area.
There are two types departure from a CSR: regularity and clustering.
Figure 1 gives an example of a complete random, regular and a clustered
pattern.

![complete spatial randomness](v_qcount_1.png)
![regularity](v_qcount_2.png)
![clustering](v_qcount_3.png)  
*Figure 1: Realization of two-dimensional Poisson processes of 50 points
on the unit square exhibiting (a) complete spatial randomness, (b)
regularity, and (c) clustering.*

Various indices and statistics measure departure from CSR. The
*v.qcount* function implements six different *quadrat count* indices
that are described in Cressie (1991; p. 590-591)\[1\] and in Ripley
(1981; p. 102-106)\[2\] and summarized in Table 1.

![Indices for Quadrat Count Data](v_qcount_5.png)  
*Table 1: Indices for Quadrat Count Data. Adapted from Cressie \[1\],
this table shows the statistics computed for the quadrats in Figure 2.*

These indices are computed as follows: *v.qcount* chooses **nquadrads**
circular quadrats of radius **radius** such that they are completely
within the bounds of the current region and no two quadrats overlap. The
number of points falling within each quadrat are counted and indices are
calculated to estimate the departure of point locations from complete
spatial randomness. This is illustrated in Figure 2.

![Figure 2: Randomly placed quadrats (n = 100) with 584 sample points.](v_qcount_4.png)  
*Figure 2: Randomly placed quadrats (n = 100) with 584 sample points.*

The number of points is written as category to the **output** map (and
not to an attribute table).

## NOTES

This program may not work properly with lat-long data. It uses *hypot()*
in two files: *count.c* and *findquads.c*.

## KNOWN ISSUES

Timestamp not working for header part of counts output. (2000-10-28)

## REFERENCES

**General references include:**

\[1\] Noel A. C. Cressie. *Statistics for Spatial Data*. Wiley Series in
Probability and Mathematical Statistics. John Wiley & Sons, New York,
NY, 1st edition, 1991.

\[2\] Brian D. Ripley. *Spatial Statistics*. John Wiley \\ Sons, New
York, NY, 1981.

**References to the indices include:**

\[3\] R. A. Fisher, H. G. Thornton, and W. A. Mackenzie. The accuracy of
the plating method of estimating the density of bacterial populations.
*Annals of Applied Biology*, 9:325-359, 1922.

\[4\] F. N. David and P. G. Moore. Notes on contagious distributions in
plant populations. *Annals of Botany*, 18:47-53, 1954.

\[5\] J. B. Douglas. Clustering and aggregation. *Sankhya B*,
37:398-417, 1975.

\[6\] M. Lloyd. Mean crowding. *Journal of Animal Ecology*, 36:1-30,
1967.

\[7\] M. Morista. Measuring the dispersion and analysis of distribution
patterns. *Memoires of the Faculty of Science, Kyushu University, Series
E. Biology*, 2:215-235, 1959.

**A more detailed background is given in the tutorial:**

\[8\] James Darrell McCauley 1993. Complete Spatial Randomness and
Quadrat Methods - [GRASS Tutorial on
v.qcount](https://grass.osgeo.org/history_docs/v_qcount_tutorial.pdf)

## SEE ALSO

*[v.random](v.random.md), [v.distance](v.distance.md),
[v.neighbors](v.neighbors.md), [v.perturb](v.perturb.md)*

## AUTHORS

[James Darrell McCauley](http://mccauley-usa.com/)  
when he was at: [Agricultural
Engineering](http://ABE.www.ecn.purdue.edu/ABE/) [Purdue
University](http://www.purdue.edu/)

Modified for GRASS 5.0 by Eric G. Miller (2000-10-28)  
Modified for GRASS 5.7 by R. Blazek (2004-10-14)

## SOURCE CODE

Available at: [v.qcount source code](https://github.com/OSGeo/grass/tree/main/vector/v.qcount)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.qcount))  
Latest change: Tuesday Feb 25 14:08:58 2025 in commit [429a884](https://github.com/OSGeo/grass/commit/429a8843c38637325f11575789155d5888d03270)
