---
hide:
  - toc
---

# Topic: map management

| Tool | Description |
|--------|-------------|
| [g.access](g.access.md) | Controls access to the current mapset for other users on the system. If no option given, prints current status. |
| [g.copy](g.copy.md) | Creates copies of maps and other elements Copies available data files in the current mapset search path to the user's current mapset. |
| [g.dirseps](g.dirseps.md) | Internal GRASS utility for converting directory separator characters. Converts any directory separator characters in the input string to or from native host format, and writes the changed path to standard output. Useful in scripts for Windows compatibility. |
| [g.filename](g.filename.md) | Prints GRASS data base file names. |
| [g.findetc](g.findetc.md) | Searches for GRASS support files. |
| [g.findfile](g.findfile.md) | Searches for GRASS data base files and sets variables for the shell. |
| [g.list](g.list.md) | Lists available GRASS data base files of the user-specified data type optionally using the search pattern. |
| [g.remove](g.remove.md) | Removes data base element files from the user's current mapset using the search pattern. |
| [g.rename](g.rename.md) | Renames data base element files in the user's current mapset. |
| [i.group](i.group.md) | Creates, edits, and lists groups of imagery data. |
| [i.target](i.target.md) | Targets an imagery group to a GRASS location and mapset. |
| [r.compress](r.compress.md) | Compresses and decompresses raster maps. |
| [r.null](r.null.md) | Manages NULL-values of given raster map. |
| [r3.null](r3.null.md) | Explicitly create the 3D NULL-value bitmap file. |
| [t.create](t.create.md) | Creates a space time dataset. |
| [t.list](t.list.md) | Lists space time datasets and maps registered in the temporal database. |
| [t.rast.list](t.rast.list.md) | Lists registered maps of a space time raster dataset. |
| [t.rast3d.list](t.rast3d.list.md) | Lists registered maps of a space time raster3d dataset. |
| [t.register](t.register.md) | Assigns timestamps and registers raster, vector and raster3d maps in a space time dataset. |
| [t.remove](t.remove.md) | Removes space time datasets from temporal database. |
| [t.rename](t.rename.md) | Renames a space time dataset |
| [t.unregister](t.unregister.md) | Unregisters raster, vector and raster3d maps from the temporal database or a specific space time dataset. |
| [t.vect.list](t.vect.list.md) | Lists registered maps of a space time vector dataset. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [map management] } -->
