---
name: r3.timestamp
description: Modifies a timestamp for a 3D raster map. Print/add/remove a timestamp for a 3D raster map.
keywords: [ raster3d, metadata, timestamp, time, voxel ]
---

# r3.timestamp

Modifies a timestamp for a 3D raster map.

Print/add/remove a timestamp for a 3D raster map.

=== "Command line"

    **r3.timestamp**
    **map**=*name*
    [**date**=*timestamp*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.timestamp map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.timestamp***",
        **map**,
        **date**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.timestamp", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_timestamp*(**map**,
        **date**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_timestamp(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    **date**=*timestamp*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime, datetime1/datetime2, or none  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime, datetime1/datetime2, or none  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *timestamp*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Datetime, datetime1/datetime2, or none  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *timestamp*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This command has 2 modes of operation. If no **date** argument is
supplied, then the current timestamp for the 3D raster map is printed.
If a date argument is specified, then the timestamp for the 3D raster
map is set to the specified date(s). See examples below.

See [TIMESTAMP FORMAT](r.timestamp.md#timestamp-format) description for
details.

## NOTES

Strings containing spaces should be quoted. For specifying a range of
time, the two timestamps should be separated by a forward slash. To
remove the timestamp from a 3D raster map, use **date=none**.

## EXAMPLES

Prints the timestamp for the "soils" 3D raster map. If there is no
timestamp for soils, nothing is printed. If there is a timestamp, one or
two lines are printed, depending on if the timestamp for the map
consists of a single date or two dates (ie start and end dates).

```sh
r3.timestamp map=soils
```

Sets the timestamp for "soils" to the single date "15 sep 1987".

```sh
r3.timestamp map=soils date='15 sep 1987'
```

Sets the timestamp for "soils" to have the start date "15 sep 1987" and
the end date "20 feb 1988".

```sh
r3.timestamp map=soils date='15 sep 1987/20 feb 1988'
```

Sets the timestamp for "soils" to have the start date "18 feb 2005
10:30:00" and the end date "20 jul 2007 20:30:00".

```sh
r3.timestamp map=soils date='18 feb 2005 10:30:00/20 jul 2007 20:30:00'
```

Removes the timestamp for the "soils" 3D raster map.

```sh
r3.timestamp map=soils date=none
```

## KNOWN ISSUES

Spaces in the timestamp value are required.

## SEE ALSO

*[r3.info](r3.info.md), [r.timestamp](r.timestamp.md),
[v.timestamp](v.timestamp.md)*

## AUTHORS

Michael Pelizzari  
Lockheed Martin Space Systems  
based on r.timestamp by Michael Shapiro,  
U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r3.timestamp source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.timestamp)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.timestamp))  
Latest change: Friday Mar 07 07:39:48 2025 in commit [e1e37d8](https://github.com/OSGeo/grass/commit/e1e37d87e78212dfcf4c97aaf32c54042adbd2b0)
