---
name: r.buildvrt
description: Build a VRT (Virtual Raster) from the list of input raster maps.
keywords: [ raster, mosaic, virtual raster ]
---

# r.buildvrt

Build a VRT (Virtual Raster) from the list of input raster maps.

=== "Command line"

    **r.buildvrt**
    [**input**=*name* [,*name*,...]]
    [**file**=*name*]
    **output**=*name*
    [**title**=*phrase*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.buildvrt output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.buildvrt***",
        **input**=*None*,
        **file**=*None*,
        **output**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.buildvrt", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_buildvrt*(**input**=*None*,
        **file**=*None*,
        **output**,
        **title**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_buildvrt(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster files  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one raster map name per line  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster files  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one raster map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster files  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one raster map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.buildvrt* builds a virtual raster (VRT) that is a mosaic of the list
of input raster maps. The purpose of such a VRT is to provide fast
access to small subsets of the VRT, also with multiple simultaneous read
requests.

## NOTES

*r.buildvrt* creates a list of raster maps that can be located in
different mapsets. The output is a read-only link to the original raster
maps which is only valid if the original raster maps remain in the
originally indicated mapset. A VRT can also be built from raster maps
registered with *[r.external](r.external.md)*. However, GRASS VRTs built
from external registered data (see below) are known to have performance
issues.

Reading the whole VRT is slower than reading the equivalent single
raster map. Only reading small parts of the VRT provides a performance
benefit.

A GRASS virtual raster can be regarded as a simplified version of GDAL's
[virtual raster
format](https://gdal.org/en/stable/drivers/raster/vrt.html). The GRASS
equivalent is simpler because issues like nodata, projection,
resolution, resampling, masking are already handled by native GRASS
raster routines.

## EXAMPLES

### VRT from a DEM in the North Carolina sample dataset

In this exercise a low resolution DEM is resampled to a high resolution
DEM. This is subsequently cut into small tiles and from that a virtual
tile mosaik is created:

```sh
# set the computational region to elevation map
g.region raster=elev_state_500m -p
# enforce higher resolution
g.region res=50 -p
# resample the 500 meter DEM to 50 meter resolution
r.resamp.interp input=elev_state_500m output=elev_state_50m method=bilinear
# create tiles from resulting large 50 m elevation map
r.tile input=elev_state_50m output=elev_state_50m_tile_ width=1000 height=1000 overlap=0
# for convenience, dump list of tile names to a file
g.list type=raster pattern=elev_state_50m_tile_* output=tilelist.csv
# build a mosaik as VRT from tile list
r.buildvrt file=tilelist.csv output=elev_state_50m_vrt
```

## KNOWN ISSUES

Users may experience significant performance degradation with virtual
rasters built with *r.buildvrt* over GDAL-linked (*r.external*) raster
maps, especially on slower file systems with latency like NFS.
Performance degradation may also occur on local file systems, but is
usually less severe. For such use cases consider using the GRASS
addon
[r.buildvrt.gdal](https://grass.osgeo.org/grass-stable/manuals/addons/r.buildvrt.gdal.html)
or building GDAL VRTs, e.g. with *gdalbuildvrt*.

## SEE ALSO

*[r.tile](r.tile.md), [r.patch](r.patch.md), [r.external](r.external.md)
[r.buildvrt.gdal](https://grass.osgeo.org/grass-stable/manuals/addons/r.buildvrt.gdal.html)*

The equivalent GDAL utility
*[gdalbuildvrt](https://gdal.org/en/stable/programs/gdalbuildvrt.html)*

## AUTHOR

Markus Metz  
Sponsored by [mundialis](https://www.mundialis.de)

## SOURCE CODE

Available at: [r.buildvrt source code](https://github.com/OSGeo/grass/tree/main/raster/r.buildvrt)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.buildvrt))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
