---
name: r.basins.fill
description: Generates watershed subbasins raster map.
keywords: [ raster, hydrology, watershed ]
---

# r.basins.fill

Generates watershed subbasins raster map.

=== "Command line"

    **r.basins.fill**
    **cnetwork**=*name*
    **tnetwork**=*name*
    **output**=*name*
    **number**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.basins.fill cnetwork=name tnetwork=name output=name number=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.basins.fill***",
        **cnetwork**,
        **tnetwork**,
        **output**,
        **number**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.basins.fill", cnetwork="name", tnetwork="name", output="name", number=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_basins_fill*(**cnetwork**,
        **tnetwork**,
        **output**,
        **number**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_basins_fill(cnetwork="name", tnetwork="name", output="name", number=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **cnetwork**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input coded stream network raster map  
    **tnetwork**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input thinned ridge network raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **number**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of passes through the dataset  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **cnetwork** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input coded stream network raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tnetwork** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input thinned ridge network raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **number** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of passes through the dataset  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **cnetwork** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input coded stream network raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tnetwork** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input thinned ridge network raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **number** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of passes through the dataset  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.basins.fill* generates a raster map layer depicting subbasins, based
on input raster map layers for the coded stream network (where each
channel segment has been "coded" with a unique category value) and for
the ridges within a given watershed. The raster map layer depicting
ridges should include the ridge which defines the perimeter of the
watershed. The coded stream network can be generated as part of the
*[r.watershed](r.watershed.md)* program, but the map layer of ridges
will need to be created by hand (for example, through digitizing done in
*[wxGUI vector digitizer](wxGUI.vdigit.md)*).

The resulting output raster map layer will code the subbasins with
category values matching those of the channel segments passing through
them. A user-supplied number of passes through the data is made in an
attempt to fill in these subbasins. If the resulting map layer from this
program appears to have holes within a subbasin, the program should be
rerun with a higher number of passes.

## NOTES

The current geographic region setting is ignored. Instead, the
geographic region for the entire input stream's map layer is used.

## SEE ALSO

See Appendix A of the **GRASS** [Tutorial:
r.watershed](https://grass.osgeo.org/gdp/raster/r.watershed.ps) for
further details on the combined use of *r.basins.fill* and
*r.watershed*.

*[r.water.outlet](r.water.outlet.md), [r.watershed](r.watershed.md),
[wxGUI vector digitizer](wxGUI.vdigit.md)*

## AUTHORS

Dale White, Dept. of Geography, Pennsylvania State University  
Larry Band, Dept. of Geography, University of Toronto, Canada

## SOURCE CODE

Available at: [r.basins.fill source code](https://github.com/OSGeo/grass/tree/main/raster/r.basins.fill)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.basins.fill))  
Latest change: Tuesday Mar 04 21:25:20 2025 in commit [9227329](https://github.com/OSGeo/grass/commit/9227329b2af8a13e1ab2730b5c863bf096510a46)
