---
name: g.remove
description: Removes data base element files from the user's current mapset using the search pattern.
keywords: [ general, map management, remove ]
---

# g.remove

Removes data base element files from the user's current mapset using the search pattern.

=== "Command line"

    **g.remove**
    [**-irefb**]
    **type**=*datatype* [,*datatype*,...]
    [**name**=*string* [,*string*,...]]
    [**ignore**=*string* [,*string*,...]]
    [**pattern**=*string*]
    [**exclude**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.remove type=raster pattern=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.remove***",
        **type**,
        **name**=*None*,
        **ignore**=*None*,
        **pattern**=*None*,
        **exclude**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.remove", type="raster", pattern="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_remove*(**type**,
        **name**=*None*,
        **ignore**=*None*,
        **pattern**=*None*,
        **exclude**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_remove(type="raster", pattern="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **type**=*datatype* [,*datatype*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, raster_3d, vector, label, region, group, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster**: raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster_3d**: 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vector**: vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**label**: paint label file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: region definition(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**group**: imagery group(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: all types  
    **name**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to remove  
    **ignore**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to ignore (default: none)  
    **pattern**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name search pattern  
    **exclude**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name exclusion pattern (default: none)  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore case  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use basic regular expressions instead of wildcards  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use extended regular expressions instead of wildcards  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove base raster maps  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datatype*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, raster_3d, vector, label, region, group, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster**: raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster_3d**: 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vector**: vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**label**: paint label file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: region definition(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**group**: imagery group(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: all types  
    **name** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, element  
    **ignore** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to ignore (default: none)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, element  
    **pattern** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name search pattern  
    **exclude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name exclusion pattern (default: none)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *r*, *e*, *f*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore case  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use basic regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use extended regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove base raster maps  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datatype*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, raster_3d, vector, label, region, group, all*  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster**: raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**raster_3d**: 3D raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vector**: vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**label**: paint label file(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**region**: region definition(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**group**: imagery group(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**all**: all types  
    **name** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, element  
    **ignore** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to ignore (default: none)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, element  
    **pattern** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name search pattern  
    **exclude** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File name exclusion pattern (default: none)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *r*, *e*, *f*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore case  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use basic regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use extended regular expressions instead of wildcards  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force removal (required for actual deletion of files)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove base raster maps  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.remove* removes data files matching a pattern given by wildcards or
POSIX Extended Regular Expressions. If the **-f** force flag is not
given then nothing is removed, instead the list of selected file names
is printed to `stdout` as a preview of the files to be deleted.

## EXAMPLES

Delete `map1` and `map2` raster maps in the current mapset:

```sh
g.remove -f type=raster name=tmp1,tmp2
```

Delete all raster and vector maps starting with "`tmp_`" in the current
mapset:

```sh
# show matching raster and vector maps but do not delete yet (as verification)
g.remove type=raster,vector pattern="tmp_*"

# actually delete the matching raster and vector maps
g.remove -f type=raster,vector pattern="tmp_*"
```

Delete all vector maps starting with "`stream_`" in the current mapset,
but exclude those ending with "`_final`":

```sh
g.remove -f type=vector pattern="stream_*" exclude="*_final"
```

## AUTHOR

Huidae Cho  
<grass4u@gmail.com>

## SOURCE CODE

Available at: [g.remove source code](https://github.com/OSGeo/grass/tree/main/general/g.remove)
([history](https://github.com/OSGeo/grass/commits/main/general/g.remove))  
Latest change: Thursday May 08 14:35:40 2025 in commit [9528b1e](https://github.com/OSGeo/grass/commit/9528b1e38ba37992c1597a979dc3efbb07b74ec5)
