---
name: d.where
description: Identifies the geographic coordinates associated with point locations given in display coordinates.
keywords: [ display, sampling, position, querying ]
---

# d.where

Identifies the geographic coordinates associated with point locations given in display coordinates.

=== "Command line"

    **d.where**
    [**-dlwf**]
    [**at**=*x,y* [,*x,y*,...]]
    [**input**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.where
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.where***",
        **at**=*None*,
        **input**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.where")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_where*(**at**=*None*,
        **input**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_where()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **at**=*x,y* [,*x,y*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Display coordinates to convert  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File from which to read coordinates ("-" to read from stdin)  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output lat/long in decimal degree  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output lat/long referenced to current ellipsoid  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output lat/long referenced to WGS84 ellipsoid using datum transformation parameters defined in current location (if available)  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output frame coordinates of current display monitor (percentage)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **at** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Display coordinates to convert  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File from which to read coordinates ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *l*, *w*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output lat/long in decimal degree  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output lat/long referenced to current ellipsoid  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output lat/long referenced to WGS84 ellipsoid using datum transformation parameters defined in current location (if available)  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output frame coordinates of current display monitor (percentage)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **at** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Display coordinates to convert  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File from which to read coordinates ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *l*, *w*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output lat/long in decimal degree  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output lat/long referenced to current ellipsoid  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output lat/long referenced to WGS84 ellipsoid using datum transformation parameters defined in current location (if available)  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output frame coordinates of current display monitor (percentage)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.where* is an *interactive* program that allows the user, using the
pointing device (mouse), to identify the geographic coordinates
associated with point locations within the current geographic region in
the active display frame on the graphics monitor.

Each mouse click will output the easting and northing of the point
currently located beneath the mouse pointer. A mouse-button menu is
presented so the user knows which mouse buttons to use. The output is
always printed to the terminal screen; if the output is redirected into
a file, it will be written to the file as well.

Mouse buttons:

```sh
     Left:   where am i
     Middle: draw to/from here
     Right:  quit this
```

The left mouse button prints the coordinates at the selected point, the
middle mouse button allows you to query two points (they are connected
by a line for convenience). Use the right mouse button to exit the
module.

## NOTES

This program uses the current geographic region setting and active
frame. It is not necessary, although useful, to have displayed a map in
the current frame before running *d.where*. The **-d** flag allows the
user to optionally output latitude/longitude coordinates pair(s) in
decimal degree rather than DD:MM:SS format. The **-w** flag is only
valid if a datum is defined for the current project's coordinate
reference system. If the **-f** flag is given the x,y frame coordinates
of the active display monitor will be returned (as a percentage, 0,0 is
bottom left).

## EXAMPLE

Query position in map (North Carolina sample dataset):

```sh
d.rast elevation
d.where
```

## SEE ALSO

*[d.what.rast](d.what.rast.md), [d.what.vect](d.what.vect.md),
[g.region](g.region.md), [v.what.rast](v.what.rast.md),
[v.what.vect](v.what.vect.md)*

## AUTHORS

James Westervelt,  
Michael Shapiro,  
U.S. Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [d.where source code](https://github.com/OSGeo/grass/tree/main/display/d.where)
([history](https://github.com/OSGeo/grass/commits/main/display/d.where))  
Latest change: Monday Dec 08 21:47:55 2025 in commit [d3c6479](https://github.com/OSGeo/grass/commit/d3c6479bef77a58e3b5d85259303dbfb9c1babe8)
